/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.skinfactory.skins;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;

import org.ametys.core.cocoon.JSonReader;
import org.ametys.web.skin.actions.UploadSkinAction;

/**
 * This action receive a form with the "importfile" zip file as an exported model.
 */
public class UploadModelAction extends UploadSkinAction
{
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        Map<String, Object> result = new LinkedHashMap<>();

        try
        {
            // Checking file
            Part part = (Part) request.get("importfile");
            if (part instanceof RejectedPart || part == null)
            {
                result.put("success", false);
                result.put("error", "rejected");
            }
            else
            {
                // Getting file
                PartOnDisk uploadedFilePart = (PartOnDisk) part;
                File uploadedFile = uploadedFilePart.getFile();
                
                String filename = (String) uploadedFilePart.getHeaders().get("filename");
                String modelName = filename.substring(0, filename.length() - 4);
                
                if (getLogger().isDebugEnabled())
                {
                    getLogger().debug("Uploading model" + modelName);
                }
    
                // Unzipping in tmp
                File dir = _unzip(uploadedFile);
                
                // Filter files
                _filter(dir, dir.getAbsolutePath(), true);
                
                result.put("skinDir", dir.getName());
                result.put("tempDir", dir.getParentFile().getName());
                result.put("skinName", modelName);
                result.put("success", "true");
            }
        }
        catch (Exception e)
        {
            getLogger().error("Unable to add model", e);
            result.put("success", false);
            
            Map<String, String> ex = new HashMap<>();
            ex.put("message", e.getMessage());

            result.put("error", ex);
        }
        
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        
        return result;    
    }
}
