/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.plugins.survey.repository.SurveyRule;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.site.CopyUpdater;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class SurveyCopyUpdater
implements CopyUpdater,
ThreadSafe,
Serviceable,
LogEnabled {
    private AmetysObjectResolver _resolver;
    private Logger _logger;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void updateSite(Site initialSite, Site createdSite) {
        ModifiableTraversableAmetysObject pluginsNode = createdSite.getRootPlugins();
        for (Sitemap sitemap : createdSite.getSitemaps()) {
            try {
                ModifiableTraversableAmetysObject surveysNode = (ModifiableTraversableAmetysObject)pluginsNode.getChild("survey/ametys:surveys/" + sitemap.getSitemapName());
                AmetysObjectIterable surveys = surveysNode.getChildren();
                for (Survey survey : surveys) {
                    for (SurveyPage cPage : survey.getPages()) {
                        this._updateRulesAfterCopy(survey, cPage);
                    }
                }
            }
            catch (UnknownAmetysObjectException unknownAmetysObjectException) {
            }
        }
    }

    private void _updateRulesAfterCopy(Survey cSurvey, SurveyPage cPage) {
        SurveyRule rule;
        String pageId;
        if (cPage.hasRule() && (pageId = (rule = cPage.getRule()).getPage()) != null) {
            try {
                AmetysObject originalPage = this._resolver.resolveById(pageId);
                AmetysObject symmetricPage = cSurvey.getChild(originalPage.getName());
                cPage.setRule(rule.getType(), symmetricPage.getId());
            }
            catch (UnknownAmetysObjectException e) {
                this._logger.warn("Symmetric page has not found during copy. The rule is deleted.");
                cPage.deleteRule();
            }
        }
        for (SurveyQuestion cQuestion : cPage.getQuestions()) {
            this._updateRulesAfterCopy(cSurvey, cQuestion);
        }
    }

    private void _updateRulesAfterCopy(Survey cSurvey, SurveyQuestion cQuestion) {
        for (SurveyRule cRule : cQuestion.getRules()) {
            String pageId = cRule.getPage();
            if (pageId == null) continue;
            String option = cRule.getOption();
            try {
                AmetysObject originalPage = this._resolver.resolveById(pageId);
                AmetysObject symmetricPage = cSurvey.getChild(originalPage.getName());
                SurveyRule.RuleType type = cRule.getType();
                cQuestion.deleteRule(option);
                cQuestion.addRules(option, type, symmetricPage.getId());
            }
            catch (UnknownAmetysObjectException e) {
                this._logger.warn("Symmetric page has not found during copy. The rule is deleted.");
                cQuestion.deleteRule(option);
            }
        }
    }

    public void updateContent(Site initialSite, Site createdSite, Content initialContent, Content createdContent) {
    }

    public void updatePage(Site initialSite, Site createdSite, Page page) {
    }
}

