/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.survey.dao.SurveyDAO;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetSurveysAction
extends ServiceableAction {
    protected static final String SURVEY_TYPE = "survey";
    protected static final String SURVEY_PAGE_TYPE = "page";
    protected static final String SURVEY_QUESTION_TYPE = "question";
    protected AmetysObjectResolver _resolver;
    protected SiteManager _siteManager;
    protected SurveyDAO _surveyDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._surveyDAO = (SurveyDAO)((Object)serviceManager.lookup(SurveyDAO.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        String nodeId = (String)jsParameters.get("node");
        String lang = (String)jsParameters.get("lang");
        String siteName = (String)jsParameters.get("siteName");
        boolean surveyOnly = (Boolean)jsParameters.get("surveyOnly");
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        try {
            if (StringUtils.isEmpty((CharSequence)nodeId) || "survey-root-node".equals(nodeId)) {
                ModifiableTraversableAmetysObject rootNode = this.getSurveyRootNode(siteName, lang);
                AmetysObjectIterable surveys = rootNode.getChildren();
                AmetysObjectIterator ametysObjectIterator = surveys.iterator();
                while (ametysObjectIterator.hasNext()) {
                    Survey survey = (Survey)((Object)ametysObjectIterator.next());
                    nodes.add(this.surveyToJSON(survey, surveyOnly));
                }
            } else if (!surveyOnly) {
                AmetysObject object = this._resolver.resolveById(nodeId);
                if (object instanceof Survey) {
                    for (AmetysObject ametysObject : ((Survey)object).getPages()) {
                        nodes.add(this.surveyPageToJSON((SurveyPage)ametysObject));
                    }
                } else if (object instanceof SurveyPage) {
                    for (AmetysObject ametysObject : ((SurveyPage)object).getChildren()) {
                        nodes.add(this.surveyQuestionToJSON((SurveyQuestion)ametysObject));
                    }
                }
            }
        }
        catch (RepositoryException e) {
            throw new ProcessingException("Unable to get surveys", (Throwable)e);
        }
        HashMap<String, ArrayList<Map<String, Object>>> result = new HashMap<String, ArrayList<Map<String, Object>>>();
        result.put("children", nodes);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Map<String, Object> surveyToJSON(Survey survey, boolean surveyOnly) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", survey.getId());
        infos.put("type", SURVEY_TYPE);
        infos.put("name", survey.getName());
        infos.put("private", this._surveyDAO.isPrivate(survey));
        infos.put("validated", survey.isValidated());
        infos.put("title", survey.getTitle());
        infos.put("label", survey.getLabel());
        infos.put("description", survey.getDescription());
        infos.put("endingMessage", survey.getEndingMessage());
        infos.put("hasChildren", !surveyOnly && survey.getPages().size() > 0);
        return infos;
    }

    protected Map<String, Object> surveyPageToJSON(SurveyPage page) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", page.getId());
        infos.put("type", SURVEY_PAGE_TYPE);
        infos.put("label", page.getLabel());
        infos.put("title", page.getTitle());
        infos.put("description", page.getDescription());
        infos.put("hasChildren", page.getChildren().getSize() > 0L);
        return infos;
    }

    protected Map<String, Object> surveyQuestionToJSON(SurveyQuestion question) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", question.getId());
        infos.put("type", SURVEY_QUESTION_TYPE);
        infos.put("name", question.getName());
        infos.put("questionType", question.getType().name());
        infos.put("mandatory", question.isMandatory());
        infos.put("validated", question.getSurvey().isValidated());
        infos.put("label", question.getLabel());
        infos.put("title", question.getTitle());
        infos.put("hasChildren", false);
        return infos;
    }

    protected ModifiableTraversableAmetysObject getSurveyRootNode(String siteName, String lang) throws RepositoryException {
        ModifiableTraversableAmetysObject pluginsNode = this._siteManager.getSite(siteName).getRootPlugins();
        ModifiableTraversableAmetysObject surveyNode = null;
        surveyNode = !pluginsNode.hasChild(SURVEY_TYPE) ? (ModifiableTraversableAmetysObject)((ModifiableTraversableAmetysObject)pluginsNode.createChild(SURVEY_TYPE, "ametys:unstructured")).createChild("ametys:surveys", "ametys:unstructured") : (ModifiableTraversableAmetysObject)pluginsNode.getChild("survey/ametys:surveys");
        if (!surveyNode.hasChild(lang)) {
            surveyNode.createChild(lang, "ametys:unstructured");
            ((JCRAmetysObject)pluginsNode).getNode().getSession().save();
        }
        return (ModifiableTraversableAmetysObject)pluginsNode.getChild("survey/ametys:surveys/" + lang);
    }
}

