/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.answer;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.survey.SurveyDateUtils;
import org.ametys.plugins.survey.answer.SurveyErrors;
import org.ametys.plugins.survey.data.SurveyAnswer;
import org.ametys.plugins.survey.data.SurveyAnswerDao;
import org.ametys.plugins.survey.data.SurveySession;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyAccessHelper;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.plugins.survey.repository.SurveyRule;
import org.ametys.runtime.i18n.I18nizableDate;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.URIPrefixHandler;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpCookie;
import org.apache.commons.lang3.StringUtils;

public class ProcessInputAction
extends ServiceableAction {
    public static final String COOKIE_NAME = "org.ametys.survey.answeredSurveys";
    protected AmetysObjectResolver _resolver;
    protected SurveyAnswerDao _answerDao;
    protected CurrentUserProvider _userProvider;
    protected URIPrefixHandler _prefixHandler;
    protected SurveyAccessHelper _accessHelper;
    protected String _pluginName;
    private RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._answerDao = (SurveyAnswerDao)((Object)serviceManager.lookup(SurveyAnswerDao.ROLE));
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._prefixHandler = (URIPrefixHandler)serviceManager.lookup(URIPrefixHandler.ROLE);
        this._accessHelper = (SurveyAccessHelper)((Object)serviceManager.lookup(SurveyAccessHelper.ROLE));
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Response response = ObjectModelHelper.getResponse((Map)objectModel);
        this._pluginName = this.getPluginName(request);
        String surveyId = request.getParameter("surveyId");
        if (StringUtils.isNotEmpty((CharSequence)surveyId)) {
            SurveyErrors errors;
            Survey survey = (Survey)this._resolver.resolveById(surveyId);
            if (!this.checkAccess(survey, request, errors = new SurveyErrors())) {
                request.setAttribute("survey", (Object)survey);
                request.setAttribute("survey-errors", (Object)errors);
                return null;
            }
            SurveyInput surveyInput = this.getInput(survey, request);
            this.validateInput(survey, surveyInput, errors, request);
            if (errors.hasErrors()) {
                request.setAttribute("survey", (Object)survey);
                request.setAttribute("survey-errors", (Object)errors);
                return null;
            }
            this._answerDao.addSession(surveyInput);
            this.setCookie(request, response, surveyId);
            String redirectPageId = survey.getRedirection();
            if (StringUtils.isNotEmpty((CharSequence)redirectPageId)) {
                try {
                    Page page = (Page)this._resolver.resolveById(redirectPageId);
                    redirector.globalRedirect(false, this._prefixHandler.getAbsoluteUriPrefix(page.getSiteName()) + "/" + page.getSitemapName() + "/" + page.getPathInSitemap() + ".html");
                }
                catch (UnknownAmetysObjectException e) {
                    this.getLogger().warn("The survey '" + survey.getId() + "' wants to redirect to the unexisting page '" + redirectPageId + "'. Redirecting to default page.", (Throwable)e);
                }
            }
        }
        return EMPTY_MAP;
    }

    protected String getPluginName(Request request) {
        return (String)request.getAttribute("pluginName");
    }

    protected boolean checkAccess(Survey survey, Request request, SurveyErrors errors) {
        UserIdentity user = this.getAuthenticatedUser(request);
        if (!this._rightManager.hasReadAccess(user, (Object)survey)) {
            errors.addErrors("survey-access", Collections.singletonList(new I18nizableText("plugin." + this._pluginName, "PLUGINS_SURVEY_RENDER_UNAUTHORIZED")));
            return false;
        }
        String surveyId = survey.getId();
        Date submissionDate = this._accessHelper.getSubmissionDate(surveyId, user);
        if (submissionDate != null) {
            LocalDate localDate = DateUtils.asLocalDate((Date)submissionDate);
            HashMap<String, I18nizableDate> i18nParams = new HashMap<String, I18nizableDate>();
            i18nParams.put("date", new I18nizableDate(localDate, FormatStyle.MEDIUM));
            errors.addErrors("survey-access", Collections.singletonList(new I18nizableText("plugin." + this._pluginName, "PLUGINS_SURVEY_RENDER_ALREADY_TAKEN_ON", i18nParams)));
            return false;
        }
        if (user == null && this._accessHelper.getCookieName(request, survey) != null) {
            errors.addErrors("survey-access", Collections.singletonList(new I18nizableText("plugin." + this._pluginName, "PLUGINS_SURVEY_RENDER_ALREADY_TAKEN")));
            return false;
        }
        return true;
    }

    protected UserIdentity getAuthenticatedUser(Request request) {
        return this._userProvider.getUser();
    }

    protected SurveyInput getInput(Survey survey, Request request) {
        String clientIp = this.getClientIp(request);
        UserIdentity user = this.getAuthenticatedUser(request);
        SurveyInput surveySession = new SurveyInput(this);
        ArrayList<SurveyInputAnswer> answers = new ArrayList<SurveyInputAnswer>();
        surveySession.setSurveyId(survey.getId());
        surveySession.setSubmittedAt(new Date());
        surveySession.setUser(user);
        surveySession.setIpAddress(clientIp);
        surveySession.setAnswerList(answers);
        try (AmetysObjectIterable<SurveyQuestion> questions = survey.getQuestions();){
            for (SurveyQuestion question : questions) {
                Map<String, Set<String>> values = this.getValues(question, request);
                SurveyInputAnswer answer = new SurveyInputAnswer(this, question, values);
                answers.add(answer);
            }
            Object object = surveySession;
            return object;
        }
    }

    protected Map<String, Set<String>> getValues(SurveyQuestion question, Request request) {
        LinkedHashMap<String, Set<String>> values = new LinkedHashMap<String, Set<String>>();
        String name = question.getName();
        switch (question.getType()) {
            case SINGLE_MATRIX: 
            case MULTIPLE_MATRIX: {
                Set<String> options = question.getOptions().keySet();
                for (String option : options) {
                    String paramName = name + "_" + option;
                    String[] paramValues = request.getParameterValues(paramName);
                    if (paramValues == null) continue;
                    values.put(option, new HashSet<String>(Arrays.asList(paramValues)));
                }
                break;
            }
            case FREE_TEXT: 
            case MULTILINE_FREE_TEXT: {
                String[] textValues = request.getParameterValues(name);
                if (textValues == null) break;
                values.put("values", new HashSet<String>(Arrays.asList(textValues)));
                break;
            }
            default: {
                ArrayList<String> valuesAsList = new ArrayList<String>();
                String[] paramValues = request.getParameterValues(name);
                if (paramValues == null) break;
                for (String value : paramValues) {
                    if (value.equals("__internal_other")) {
                        valuesAsList.add(request.getParameter("__internal_other_" + name));
                        continue;
                    }
                    valuesAsList.add(value);
                }
                values.put("values", new HashSet(valuesAsList));
            }
        }
        return values;
    }

    protected void validateInput(Survey survey, SurveyInput input, SurveyErrors errors, Request request) {
        SurveyRule ruleToExecute = null;
        Map<String, SurveyInputAnswer> answers = input.getAnswerMap();
        for (SurveyPage page : survey.getPages()) {
            if (ruleToExecute != null && !this.processPage(page, ruleToExecute)) continue;
            ruleToExecute = null;
            AmetysObjectIterable<SurveyQuestion> questions = page.getQuestions();
            for (SurveyQuestion question : questions) {
                SurveyInputAnswer answer = answers.get(question.getName());
                switch (question.getType()) {
                    case FREE_TEXT: 
                    case MULTILINE_FREE_TEXT: {
                        errors.addErrors(question.getName(), this.validateText(answer, request));
                        ruleToExecute = this.evaluateTextRules(question, answer);
                        break;
                    }
                    case SINGLE_CHOICE: 
                    case MULTIPLE_CHOICE: {
                        errors.addErrors(question.getName(), this.validateChoice(answer, request));
                        ruleToExecute = this.evaluateChoiceRules(question, answer);
                        break;
                    }
                    case SINGLE_MATRIX: 
                    case MULTIPLE_MATRIX: {
                        errors.addErrors(question.getName(), this.validateMatrix(answer, request));
                        ruleToExecute = this.evaluateMatrixRules(question, answer);
                        break;
                    }
                }
            }
            SurveyRule pageRule = page.getRule();
            if (ruleToExecute != null || pageRule == null) continue;
            ruleToExecute = pageRule;
        }
    }

    protected boolean processPage(SurveyPage page, SurveyRule rule) {
        boolean processPage = false;
        switch (rule.getType()) {
            case JUMP: {
                processPage = page.getId().equals(rule.getPage());
                break;
            }
            case SKIP: {
                processPage = !page.getId().equals(rule.getPage());
                break;
            }
            case FINISH: {
                break;
            }
        }
        return processPage;
    }

    protected SurveyRule evaluateTextRules(SurveyQuestion question, SurveyInputAnswer answer) {
        return null;
    }

    protected SurveyRule evaluateChoiceRules(SurveyQuestion question, SurveyInputAnswer answer) {
        SurveyRule matchedRule = null;
        Map<String, Set<String>> valueMap = answer.getValuesMap();
        if (valueMap.containsKey("values")) {
            Set<String> values = answer.getValuesMap().get("values");
            Iterator<SurveyRule> questionRules = question.getRules().iterator();
            while (questionRules.hasNext() && matchedRule == null) {
                SurveyRule rule = questionRules.next();
                if (!values.contains(rule.getOption())) continue;
                matchedRule = rule;
            }
        }
        return matchedRule;
    }

    protected SurveyRule evaluateMatrixRules(SurveyQuestion question, SurveyInputAnswer answer) {
        return null;
    }

    protected List<I18nizableText> validateText(SurveyInputAnswer answer, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        SurveyQuestion question = answer.getQuestion();
        boolean isBlank = this.isBlank(answer);
        String textPrefix = "PLUGINS_SURVEY_RENDER_ERROR_TEXT_";
        if (question.isMandatory() && isBlank) {
            errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_SURVEY_RENDER_ERROR_TEXT_MANDATORY"));
        }
        if (!isBlank) {
            errors.addAll(this.validatePattern(answer, "PLUGINS_SURVEY_RENDER_ERROR_TEXT_"));
        }
        return errors;
    }

    protected List<I18nizableText> validateChoice(SurveyInputAnswer answer, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        SurveyQuestion question = answer.getQuestion();
        boolean isBlank = this.isBlank(answer);
        String textPrefix = "PLUGINS_SURVEY_RENDER_ERROR_CHOICE_";
        if (question.isMandatory() && isBlank) {
            errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_SURVEY_RENDER_ERROR_CHOICE_MANDATORY"));
        }
        return errors;
    }

    protected List<I18nizableText> validateMatrix(SurveyInputAnswer answer, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        SurveyQuestion question = answer.getQuestion();
        boolean isBlank = this.isBlank(answer);
        String textPrefix = "PLUGINS_SURVEY_RENDER_ERROR_MATRIX_";
        if (question.isMandatory() && isBlank) {
            errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_SURVEY_RENDER_ERROR_MATRIX_MANDATORY"));
        }
        return errors;
    }

    protected List<I18nizableText> validatePattern(SurveyInputAnswer answer, String keyPrefix) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        SurveyQuestion question = answer.getQuestion();
        String regex = question.getRegExpPattern();
        String value = answer.getValue();
        if (StringUtils.isNotBlank((CharSequence)regex) && !Pattern.matches(regex, value)) {
            errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "PATTERN"));
        }
        return errors;
    }

    protected boolean isBlank(SurveyInputAnswer answer) {
        boolean blank = answer.getValuesMap().isEmpty();
        for (Set<String> values : answer.getValuesMap().values()) {
            if (!StringUtils.isEmpty((CharSequence)StringUtils.join(values, (String)""))) continue;
            return true;
        }
        return blank;
    }

    protected void setCookie(Request request, Response response, String surveyId) {
        Map cookieMap = request.getCookieMap();
        Cookie cookie = null;
        String cookieValue = surveyId + "#" + SurveyDateUtils.zonedDateTimeToString(ZonedDateTime.now(ZoneId.of("UTC")));
        if (cookieMap.containsKey(COOKIE_NAME)) {
            cookie = (Cookie)cookieMap.get(COOKIE_NAME);
            String newValue = cookie.getValue() + "|" + cookieValue;
            cookie.setValue(newValue);
        } else {
            cookie = response.createCookie(COOKIE_NAME, cookieValue);
            cookie.setSecure(request.isSecure());
            ((HttpCookie)cookie).getServletCookie().setHttpOnly(false);
        }
        cookie.setVersion(1);
        cookie.setMaxAge(2592000);
        String absPrefix = this._prefixHandler.getAbsoluteUriPrefix();
        String host = null;
        try {
            URI frontUri = new URI(absPrefix);
            host = frontUri.getHost();
            String path = frontUri.getPath();
            cookie.setPath(StringUtils.isEmpty((CharSequence)path) ? "/" : path);
        }
        catch (URISyntaxException e) {
            this.getLogger().warn("The front URI seems to be invalid.", (Throwable)e);
        }
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            cookie.setDomain(host);
            response.addCookie(cookie);
        }
    }

    protected final String getClientIp(Request request) {
        String[] forwardedIps;
        String forwardedIp;
        String ip = "";
        String forwardedIpHeader = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((CharSequence)forwardedIpHeader) && StringUtils.isNotBlank((CharSequence)(forwardedIp = (forwardedIps = forwardedIpHeader.split("[\\s,]+"))[forwardedIps.length - 1]))) {
            ip = forwardedIp.trim();
        }
        if (StringUtils.isBlank((CharSequence)ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public class SurveyInput
    extends SurveySession {
        protected List<SurveyInputAnswer> _inputAnswers;

        public SurveyInput(ProcessInputAction this$0) {
        }

        public List<SurveyInputAnswer> getAnswers() {
            return this._inputAnswers;
        }

        public Map<String, SurveyInputAnswer> getAnswerMap() {
            LinkedHashMap<String, SurveyInputAnswer> answerMap = new LinkedHashMap<String, SurveyInputAnswer>();
            for (SurveyInputAnswer answer : this._inputAnswers) {
                answerMap.put(answer.getQuestionId(), answer);
            }
            return answerMap;
        }

        public void setAnswerList(List<SurveyInputAnswer> answers) {
            this._inputAnswers = answers;
        }
    }

    public class SurveyInputAnswer
    extends SurveyAnswer {
        protected SurveyQuestion _question;
        protected Map<String, Set<String>> _values;

        public SurveyInputAnswer(ProcessInputAction this$0) {
            this(this$0, null, null);
        }

        public SurveyInputAnswer(ProcessInputAction this$0, SurveyQuestion question, Map<String, Set<String>> values) {
            this._question = question;
            this._values = values;
        }

        public SurveyQuestion getQuestion() {
            return this._question;
        }

        public void setQuestion(SurveyQuestion question) {
            this._question = question;
        }

        @Override
        public String getQuestionId() {
            return this._question.getName();
        }

        @Override
        public void setQuestionId(String questionId) {
            throw new IllegalAccessError("Set the question instead of the question ID.");
        }

        public Map<String, Set<String>> getValuesMap() {
            return this._values;
        }

        public void setValueMap(Map<String, Set<String>> values) {
            this._values = values;
        }

        @Override
        public String getValue() {
            String value = "";
            switch (this._question.getType()) {
                case SINGLE_MATRIX: 
                case MULTIPLE_MATRIX: {
                    StringBuilder valueBuff = new StringBuilder();
                    for (String option : this._values.keySet()) {
                        Set<String> values = this._values.get(option);
                        if (valueBuff.length() > 0) {
                            valueBuff.append(";");
                        }
                        valueBuff.append(option).append(":").append(StringUtils.join(values, (String)","));
                    }
                    value = valueBuff.toString();
                    break;
                }
                default: {
                    value = StringUtils.defaultString((String)StringUtils.join((Iterable)this._values.get("values"), (String)","));
                }
            }
            return value;
        }

        @Override
        public void setValue(String value) {
            throw new IllegalAccessError("Set the value map instead of the vlaue.");
        }
    }
}

