/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.answer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.lang3.StringUtils;

public class SurveyErrors {
    protected Map<String, List<I18nizableText>> _errors;

    public SurveyErrors() {
        this(new LinkedHashMap<String, List<I18nizableText>>());
    }

    public SurveyErrors(Map<String, List<I18nizableText>> errors) {
        this._errors = errors;
    }

    public Map<String, List<I18nizableText>> getErrors() {
        return this._errors;
    }

    public void setErrors(Map<String, List<I18nizableText>> errors) {
        this._errors = errors;
    }

    public void addError(String fieldId, I18nizableText error) {
        if (StringUtils.isNotEmpty((CharSequence)fieldId) && error != null) {
            if (this._errors.containsKey(fieldId)) {
                this._errors.get(fieldId).add(error);
            } else {
                ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
                errors.add(error);
                this._errors.put(fieldId, errors);
            }
        }
    }

    public void addErrors(String fieldId, List<I18nizableText> errors) {
        if (StringUtils.isNotEmpty((CharSequence)fieldId) && !errors.isEmpty()) {
            if (this._errors.containsKey(fieldId)) {
                this._errors.get(fieldId).addAll(errors);
            } else {
                this._errors.put(fieldId, errors);
            }
        }
    }

    public boolean hasErrors() {
        for (List<I18nizableText> errList : this._errors.values()) {
            if (errList.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

