/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.answer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.survey.answer.SurveyErrors;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SurveyErrorsGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Survey survey = (Survey)((Object)request.getAttribute("survey"));
        SurveyErrors errors = (SurveyErrors)request.getAttribute("survey-errors");
        Map<String, List<I18nizableText>> errorMap = errors.getErrors();
        this.contentHandler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", survey.getId());
        atts.addCDATAAttribute("title", survey.getTitle());
        atts.addCDATAAttribute("label", survey.getLabel());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"survey-errors", (Attributes)atts);
        for (Map.Entry<String, List<I18nizableText>> fieldErrors : errorMap.entrySet()) {
            String questionName = fieldErrors.getKey();
            List<I18nizableText> messages = fieldErrors.getValue();
            if (StringUtils.isEmpty((CharSequence)questionName) || "survey-access".equals(questionName)) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"survey-access");
                for (I18nizableText message : messages) {
                    message.toSAX(this.contentHandler, "error");
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"survey-access");
                continue;
            }
            SurveyQuestion question = survey.getQuestion(questionName);
            atts.clear();
            atts.addCDATAAttribute("id", question.getId());
            atts.addCDATAAttribute("name", questionName);
            atts.addCDATAAttribute("label", question.getLabel());
            atts.addCDATAAttribute("title", question.getTitle());
            atts.addCDATAAttribute("type", question.getType().toString());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question", (Attributes)atts);
            for (I18nizableText message : messages) {
                message.toSAX(this.contentHandler, "error");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"survey-errors");
        this.contentHandler.endDocument();
    }
}

