/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.clientsideelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class RedirectPageClientSideElement
extends StaticClientSideElement {
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getStatus(String surveyId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Survey survey = (Survey)this._resolver.resolveById(surveyId);
        String redirectPageId = survey.getRedirection();
        if (StringUtils.isNotEmpty((CharSequence)redirectPageId)) {
            try {
                Page page = (Page)this._resolver.resolveById(redirectPageId);
                ArrayList<Object> i18nParameters = new ArrayList<Object>();
                i18nParameters.add(page.getTitle());
                i18nParameters.add(page.getSitemapName() + "/" + page.getPathInSitemap() + ".html");
                I18nizableText ed = (I18nizableText)this._script.getParameters().get("redirect-page-description");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                results.put("page-redirection", redirectPageId);
                results.put("page-redirection-description", msg);
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().warn("The redirect page of id '" + redirectPageId + "' does not exist anymore", (Throwable)e);
            }
        }
        return results;
    }
}

