/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.clientsideelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class ValidateSurveyClientSideElement
extends StaticClientSideElement {
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    @Callable(rights={"Plugins_Survey_Right_Validate"}, context="/cms")
    public Map<String, Object> getStatus(String surveyId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Survey survey = (Survey)this._resolver.resolveById(surveyId);
        boolean isValidated = survey.isValidated();
        ArrayList<String> i18nParameters = new ArrayList<String>();
        i18nParameters.add(StringUtils.isNotEmpty((CharSequence)survey.getTitle()) ? survey.getTitle() : survey.getLabel());
        I18nizableText msg = null;
        if (isValidated) {
            I18nizableText ed = (I18nizableText)this._script.getParameters().get("validated-description");
            msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
        } else {
            I18nizableText ed = (I18nizableText)this._script.getParameters().get("to-validate-description");
            msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
        }
        results.put("validate-description", msg);
        results.put("validated", Boolean.toString(isValidated));
        return results;
    }
}

