/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.dao;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.survey.dao.AbstractDAO;
import org.ametys.plugins.survey.dao.PageDAO;
import org.ametys.plugins.survey.data.SurveyAnswer;
import org.ametys.plugins.survey.data.SurveyAnswerDao;
import org.ametys.plugins.survey.data.SurveySession;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiableSitemapElement;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.site.SiteConfigurationExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class SurveyDAO
extends AbstractDAO {
    public static final String ROLE = SurveyDAO.class.getName();
    private static final String __OTHER_OPTION = "__opt_other";
    protected SurveyAnswerDao _surveyAnswerDao;
    protected PageDAO _pageDAO;
    protected SiteConfigurationExtensionPoint _siteConfiguration;
    private I18nUtils _i18nUtils;
    private RightManager _rightManager;
    private UserManager _userManager;
    private ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._surveyAnswerDao = (SurveyAnswerDao)((Object)serviceManager.lookup(SurveyAnswerDao.ROLE));
        this._pageDAO = (PageDAO)((Object)serviceManager.lookup(PageDAO.ROLE));
        this._siteConfiguration = (SiteConfigurationExtensionPoint)serviceManager.lookup(SiteConfigurationExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)serviceManager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getSurvey(String id) {
        Survey survey = (Survey)this._resolver.resolveById(id);
        return this.getSurvey(survey);
    }

    public Map<String, Object> getSurvey(Survey survey) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", survey.getId());
        properties.put("label", survey.getLabel());
        properties.put("title", survey.getTitle());
        properties.put("description", survey.getDescription());
        properties.put("endingMessage", survey.getEndingMessage());
        properties.put("private", this.isPrivate(survey));
        if (survey.getRedirection() == null) {
            properties.put("redirection", "");
        } else {
            properties.put("redirection", survey.getRedirection());
        }
        properties.putAll(this.getPictureInfo(survey));
        return properties;
    }

    public boolean isPrivate(Survey survey) {
        return !this._rightManager.hasAnonymousReadAccess((Object)survey);
    }

    @Callable(rights={"Plugins_Survey_Right_Handle", "Plugins_Survey_Right_ExportHtml"}, context="/cms")
    public Map<String, String> isOnline(String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        Survey survey = (Survey)this._resolver.resolveById(id);
        String xpathQuery = "//element(" + survey.getSiteName() + ", ametys:site)/ametys-internal:sitemaps/" + survey.getLanguage() + "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.survey.service.Display' and ametys:service_parameters/@ametys:surveyId = '" + id + "']";
        AmetysObjectIterable zoneItems = this._resolver.query(xpathQuery);
        result.put("isValid", String.valueOf(survey.isValidated()));
        result.put("isOnline", String.valueOf(zoneItems.iterator().hasNext()));
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public List<Object> getChildren(String id) {
        ArrayList<Object> result = new ArrayList<Object>();
        Survey survey = (Survey)this._resolver.resolveById(id);
        AmetysObjectIterable pages = survey.getChildren();
        for (SurveyPage page : pages) {
            result.add(this._pageDAO.getPage(page));
        }
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> createSurvey(Map<String, Object> values, String siteName, String language) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        ModifiableTraversableAmetysObject rootNode = this.getSurveyRootNode(siteName, language);
        String label = StringUtils.defaultString((String)((String)values.get("label")));
        String originalName = NameHelper.filterName((String)label);
        Object name = originalName;
        int index = 2;
        while (rootNode.hasChild((String)name)) {
            name = originalName + "-" + index++;
        }
        Survey survey = (Survey)rootNode.createChild((String)name, "ametys:survey");
        this._setValues(survey, values);
        rootNode.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", survey);
        this._observationManager.notify(new Event("survey.created", this._getCurrentUser(), eventParams));
        this._setPublicAccess(survey);
        result.put("id", survey.getId());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> editSurvey(Map<String, Object> values, String siteName, String language) {
        HashMap<String, String> result = new HashMap<String, String>();
        String id = StringUtils.defaultString((String)((String)values.get("id")));
        Survey survey = (Survey)this._resolver.resolveById(id);
        this._setValues(survey, values);
        survey.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", survey);
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", survey.getId());
        return result;
    }

    private void _setPublicAccess(Survey survey) {
        this._profileAssignmentStorageEP.allowProfileToAnonymous("READER", (Object)survey);
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("acl-context", (Object)survey);
        eventParams.put("acl-profiles", Collections.singleton("READER"));
        this._observationManager.notify(new Event("acl.update", this._currentUserProvider.getUser(), eventParams));
    }

    private void _setValues(Survey survey, Map<String, Object> values) {
        survey.setTitle(StringUtils.defaultString((String)((String)values.get("title"))));
        survey.setLabel(StringUtils.defaultString((String)((String)values.get("label"))));
        survey.setDescription(StringUtils.defaultString((String)((String)values.get("description"))));
        survey.setEndingMessage(StringUtils.defaultString((String)((String)values.get("endingMessage"))));
        survey.setPictureAlternative(StringUtils.defaultString((String)((String)values.get("picture-alternative"))));
        this.setPicture(survey, StringUtils.defaultString((String)((String)values.get("picture"))));
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> copySurvey(String surveyId, String label, String title) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String originalName = NameHelper.filterName((String)label);
        Survey surveyToCopy = (Survey)this._resolver.resolveById(surveyId);
        ModifiableTraversableAmetysObject rootNode = this.getSurveyRootNode(surveyToCopy.getSiteName(), surveyToCopy.getLanguage());
        Object name = originalName;
        int index = 2;
        while (rootNode.hasChild((String)name)) {
            name = originalName + "-" + index++;
        }
        Survey survey = surveyToCopy.copyTo(rootNode, (String)name);
        survey.setLabel(label);
        survey.setTitle(title);
        this.updateReferencesAfterCopy(surveyToCopy, survey);
        rootNode.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", survey);
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        this._setPublicAccess(survey);
        result.put("id", survey.getId());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> deleteSurvey(String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        Survey survey = (Survey)this._resolver.resolveById(id);
        ModifiableAmetysObject parent = (ModifiableAmetysObject)survey.getParent();
        String siteName = survey.getSiteName();
        survey.remove();
        this._surveyAnswerDao.deleteSessions(id);
        parent.saveChanges();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("siteName", siteName);
        this._observationManager.notify(new Event("survey.deleted", this._getCurrentUser(), eventParams));
        result.put("id", id);
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Validate"}, context="/cms")
    public Map<String, String> validateSurvey(String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        Survey survey = (Survey)this._resolver.resolveById(id);
        survey.setValidated(true);
        survey.setValidationDate(new Date());
        survey.saveChanges();
        result.put("id", survey.getId());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> reinitSurvey(String id, boolean invalidate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Survey survey = (Survey)this._resolver.resolveById(id);
        if (invalidate) {
            survey.setValidated(false);
            survey.setValidationDate(null);
            result.put("modifiedPages", this.removeExistingServices(survey.getSiteName(), survey.getLanguage(), id));
        }
        survey.reinit();
        survey.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", survey);
        this._observationManager.notify(new Event("survey.initialized", this._getCurrentUser(), eventParams));
        this._surveyAnswerDao.deleteSessions(id);
        result.put("id", survey.getId());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> setRedirection(String surveyId, String pageId) {
        HashMap<String, String> result = new HashMap<String, String>();
        Survey survey = (Survey)this._resolver.resolveById(surveyId);
        if (StringUtils.isNotEmpty((CharSequence)pageId)) {
            survey.setRedirection(pageId);
        } else {
            survey.setRedirection(null);
        }
        survey.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", survey);
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", survey.getId());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> moveObject(String id, String oldParent, String newParent, long index) throws Exception {
        Survey survey;
        HashMap<String, String> result = new HashMap<String, String>();
        JCRAmetysObject aoMoved = (JCRAmetysObject)this._resolver.resolveById(id);
        DefaultTraversableAmetysObject newParentAO = (DefaultTraversableAmetysObject)this._resolver.resolveById(newParent);
        JCRAmetysObject brother = null;
        long size = newParentAO.getChildren().getSize();
        if (index != -1L && index < size) {
            brother = (JCRAmetysObject)newParentAO.getChildAt(index);
        } else if (index >= size) {
            brother = (JCRAmetysObject)newParentAO.getChildAt((long)(Math.toIntExact(size) - 1));
        }
        Survey oldSurvey = this.getParentSurvey(aoMoved);
        if (oldSurvey != null) {
            result.put("oldSurveyId", oldSurvey.getId());
        }
        if (oldParent.equals(newParent) && brother != null) {
            node = aoMoved.getNode();
            name = "";
            try {
                name = brother.getName();
                node.getParent().orderBefore(node.getName(), (String)name);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException(String.format("Unable to order AmetysOject '%s' before sibling '%s'", new Object[]{this, name}), (Throwable)e);
            }
        } else {
            node = aoMoved.getNode();
            name = node.getName();
            int localIndex = 2;
            while (newParentAO.hasChild((String)name)) {
                name = node.getName() + "-" + localIndex++;
            }
            node.getSession().move(node.getPath(), newParentAO.getNode().getPath() + "/" + (String)name);
            if (brother != null) {
                node.getParent().orderBefore(node.getName(), brother.getName());
            }
        }
        if (newParentAO.needsSave()) {
            newParentAO.saveChanges();
        }
        if ((survey = this.getParentSurvey(aoMoved)) != null) {
            result.put("newSurveyId", survey.getId());
            HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
            eventParams.put("survey", survey);
            this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        }
        result.put("id", id);
        if (aoMoved instanceof SurveyPage) {
            result.put("type", "page");
        } else if (aoMoved instanceof SurveyQuestion) {
            result.put("type", "question");
            result.put("questionType", ((SurveyQuestion)aoMoved).getType().name());
        }
        result.put("newParentId", newParentAO.getId());
        result.put("oldParentId", oldParent);
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_LimitAccess"}, context="/cms")
    public Map<String, Object> sendInvitations(String surveyId, String message, String siteName) {
        String subject = this.getMailSubject();
        String body = this.getMailBody(surveyId, message, siteName);
        Site site = this._siteManager.getSite(siteName);
        String defaultFromValue = (String)Config.getInstance().getValue("smtp.mail.from");
        String from = (String)site.getValue("site-mail-from", false, (Object)defaultFromValue);
        Survey survey = (Survey)this._resolver.resolveById(surveyId);
        Set allowedUsers = this._rightManager.getReadAccessAllowedUsers((Object)survey).resolveAllowedUsers(false);
        for (UserIdentity userIdentity : allowedUsers) {
            User user = this._userManager.getUser(userIdentity);
            if (user == null || !StringUtils.isNotEmpty((CharSequence)user.getEmail()) || this.hasAlreadyAnswered(surveyId, userIdentity)) continue;
            try {
                String finalMessage = StringUtils.replace((String)body, (String)"[name]", (String)user.getFullName());
                SendMailHelper.newMail().withSubject(subject).withTextBody(finalMessage).withSender(from).withRecipient(user.getEmail()).sendMail();
            }
            catch (MessagingException | IOException e) {
                new SLF4JLoggerAdapter(LoggerFactory.getLogger(((Object)((Object)this)).getClass())).error("Unable to send mail to user " + user.getEmail(), e);
            }
        }
        return new HashMap<String, Object>();
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getStatistics(String id) {
        HashMap<String, Object> statistics = new HashMap<String, Object>();
        Survey survey = (Survey)this._resolver.resolveById(id);
        int sessionCount = this._surveyAnswerDao.getSessionCount(id);
        List<SurveySession> sessions = this._surveyAnswerDao.getSessionsWithAnswers(id);
        statistics.put("id", id);
        statistics.put("title", survey.getTitle());
        statistics.put("sessions", sessionCount);
        Map<String, Map<String, Map<String, Object>>> statsMap = this.createStatsMap(survey);
        this.dispatchStats(survey, sessions, statsMap);
        List<Map<String, Object>> statsList = this.statsToArray(survey, statsMap);
        statistics.put("questions", statsList);
        return statistics;
    }

    protected List<String> removeExistingServices(String siteName, String lang, String surveyId) {
        ArrayList<String> modifiedPages = new ArrayList<String>();
        for (ModifiableZoneItem zoneItem : this.getSurveyZoneItems(siteName, lang, surveyId)) {
            ModifiableSitemapElement sitemapElement = (ModifiableSitemapElement)zoneItem.getZone().getSitemapElement();
            String id = zoneItem.getId();
            ZoneItem.ZoneType type = zoneItem.getType();
            zoneItem.remove();
            sitemapElement.saveChanges();
            modifiedPages.add(sitemapElement.getId());
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("sitemapelement", sitemapElement);
            eventParams.put("zone.item.id", id);
            eventParams.put("zone.type", type);
            this._observationManager.notify(new Event("zoneitem.deleted", this._getCurrentUser(), eventParams));
        }
        return modifiedPages;
    }

    public AmetysObjectIterable<ModifiableZoneItem> getSurveyZoneItems(String siteName, String lang, String surveyId) {
        String xpathQuery = "//element(" + siteName + ", ametys:site)/ametys-internal:sitemaps/" + lang + "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.survey.service.Display' and ametys:service_parameters/@ametys:surveyId = '" + surveyId + "']";
        return this._resolver.query(xpathQuery);
    }

    protected Survey getParentSurvey(JCRAmetysObject obj) {
        try {
            JCRAmetysObject currentAo = (JCRAmetysObject)obj.getParent();
            while (!(currentAo instanceof Survey)) {
                currentAo = (JCRAmetysObject)currentAo.getParent();
            }
            if (currentAo instanceof Survey) {
                return (Survey)currentAo;
            }
        }
        catch (AmetysRepositoryException ametysRepositoryException) {
            // empty catch block
        }
        return null;
    }

    protected Map<String, Map<String, Map<String, Object>>> createStatsMap(Survey survey) {
        LinkedHashMap<String, Map<String, Map<String, Object>>> stats = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
        block5: for (SurveyQuestion question : survey.getQuestions()) {
            LinkedHashMap questionValues = new LinkedHashMap();
            stats.put(question.getName(), questionValues);
            switch (question.getType()) {
                case FREE_TEXT: 
                case MULTILINE_FREE_TEXT: {
                    LinkedHashMap<String, Integer> values = new LinkedHashMap<String, Integer>();
                    questionValues.put("values", values);
                    values.put("answered", 0);
                    values.put("empty", 0);
                    break;
                }
                case SINGLE_CHOICE: 
                case MULTIPLE_CHOICE: {
                    LinkedHashMap<String, Integer> values = new LinkedHashMap();
                    questionValues.put("values", values);
                    for (String option : question.getOptions().keySet()) {
                        values.put(option, 0);
                    }
                    if (!question.hasOtherOption()) break;
                    values.put(__OTHER_OPTION, 0);
                    break;
                }
                case SINGLE_MATRIX: 
                case MULTIPLE_MATRIX: {
                    LinkedHashMap<String, Integer> values;
                    for (String option : question.getOptions().keySet()) {
                        values = new LinkedHashMap();
                        questionValues.put(option, values);
                        for (String column : question.getColumns().keySet()) {
                            values.put(column, 0);
                        }
                    }
                    continue block5;
                }
            }
        }
        return stats;
    }

    protected void dispatchStats(Survey survey, Collection<SurveySession> sessions, Map<String, Map<String, Map<String, Object>>> stats) {
        for (SurveySession session : sessions) {
            for (SurveyAnswer surveyAnswer : session.getAnswers()) {
                SurveyQuestion question = survey.getQuestion(surveyAnswer.getQuestionId());
                if (question == null) continue;
                Map<String, Map<String, Object>> questionStats = stats.get(surveyAnswer.getQuestionId());
                Map<String, Set<String>> valueMap = this.getValueMap(question, surveyAnswer.getValue());
                switch (question.getType()) {
                    case FREE_TEXT: 
                    case MULTILINE_FREE_TEXT: {
                        this.dispatchTextStats(session, questionStats, valueMap);
                        break;
                    }
                    case SINGLE_CHOICE: 
                    case MULTIPLE_CHOICE: {
                        this.dispatchChoiceStats(session, questionStats, valueMap);
                        break;
                    }
                    case SINGLE_MATRIX: 
                    case MULTIPLE_MATRIX: {
                        this.dispatchMatrixStats(session, questionStats, valueMap);
                        break;
                    }
                }
            }
        }
    }

    protected void dispatchTextStats(SurveySession session, Map<String, Map<String, Object>> questionStats, Map<String, Set<String>> valueMap) {
        Map<String, Object> optionStats = questionStats.get("values");
        if (valueMap.containsKey("values")) {
            String singleValue = valueMap.get("values").iterator().next();
            boolean isBlank = StringUtils.isBlank((CharSequence)singleValue);
            String stat = isBlank ? "empty" : "answered";
            int iValue = (Integer)optionStats.get(stat);
            optionStats.put(stat, iValue + 1);
            if (!isBlank) {
                optionStats.put(Integer.toString(session.getId()), singleValue);
            }
        }
    }

    protected void dispatchChoiceStats(SurveySession session, Map<String, Map<String, Object>> questionStats, Map<String, Set<String>> valueMap) {
        Map<String, Object> optionStats = questionStats.get("values");
        if (valueMap.containsKey("values")) {
            for (String value : valueMap.get("values")) {
                int iValue;
                if (optionStats.containsKey(value)) {
                    iValue = (Integer)optionStats.get(value);
                    optionStats.put(value, iValue + 1);
                    continue;
                }
                iValue = (Integer)optionStats.get(__OTHER_OPTION);
                optionStats.put(__OTHER_OPTION, iValue + 1);
            }
        }
    }

    protected void dispatchMatrixStats(SurveySession session, Map<String, Map<String, Object>> questionStats, Map<String, Set<String>> valueMap) {
        for (String option : valueMap.keySet()) {
            Map<String, Object> optionStats = questionStats.get(option);
            if (optionStats == null) continue;
            for (String value : valueMap.get(option)) {
                if (!optionStats.containsKey(value)) continue;
                int iValue = (Integer)optionStats.get(value);
                optionStats.put(value, iValue + 1);
            }
        }
    }

    protected List<Map<String, Object>> statsToArray(Survey survey, Map<String, Map<String, Map<String, Object>>> stats) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String questionId : stats.keySet()) {
            HashMap<String, Object> questionMap = new HashMap<String, Object>();
            SurveyQuestion question = survey.getQuestion(questionId);
            Map<String, Map<String, Object>> questionStats = stats.get(questionId);
            questionMap.put("id", questionId);
            questionMap.put("title", question.getTitle());
            questionMap.put("type", (Object)question.getType());
            questionMap.put("mandatory", question.isMandatory());
            ArrayList options = new ArrayList();
            for (String optionId : questionStats.keySet()) {
                HashMap<String, Object> option = new HashMap<String, Object>();
                option.put("id", optionId);
                option.put("label", this.getOptionLabel(question, optionId));
                questionStats.get(optionId).entrySet();
                ArrayList choices = new ArrayList();
                for (Map.Entry<String, Object> choice : questionStats.get(optionId).entrySet()) {
                    HashMap<String, Object> choiceMap = new HashMap<String, Object>();
                    String choiceId = choice.getKey();
                    choiceMap.put("value", choiceId);
                    choiceMap.put("label", this.getChoiceLabel(question, choiceId));
                    choiceMap.put("count", choice.getValue());
                    choices.add(choiceMap);
                }
                option.put("choices", choices);
                options.add(option);
            }
            questionMap.put("options", options);
            result.add(questionMap);
        }
        return result;
    }

    protected String getOptionLabel(SurveyQuestion question, String optionId) {
        String label = "";
        switch (question.getType()) {
            case FREE_TEXT: 
            case MULTILINE_FREE_TEXT: 
            case SINGLE_CHOICE: 
            case MULTIPLE_CHOICE: {
                break;
            }
            case SINGLE_MATRIX: 
            case MULTIPLE_MATRIX: {
                label = question.getOptions().get(optionId);
                break;
            }
        }
        return label;
    }

    protected String getChoiceLabel(SurveyQuestion question, String choiceId) {
        String label = "";
        switch (question.getType()) {
            case FREE_TEXT: 
            case MULTILINE_FREE_TEXT: {
                break;
            }
            case SINGLE_CHOICE: 
            case MULTIPLE_CHOICE: {
                if (question.getOptions().containsKey(choiceId)) {
                    label = question.getOptions().get(choiceId);
                    break;
                }
                if (!question.hasOtherOption()) break;
                label = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.survey", "PLUGINS_SURVEY_STATISTICS_OTHER_OPTION"));
                break;
            }
            case SINGLE_MATRIX: 
            case MULTIPLE_MATRIX: {
                label = question.getColumns().get(choiceId);
                break;
            }
        }
        return label;
    }

    protected Map<String, Set<String>> getValueMap(SurveyQuestion question, String value) {
        HashMap<String, Set<String>> values = new HashMap<String, Set<String>>();
        if (value != null) {
            switch (question.getType()) {
                case SINGLE_MATRIX: 
                case MULTIPLE_MATRIX: {
                    String[] entries;
                    for (String entry : entries = StringUtils.split((String)value, (char)';')) {
                        String[] keyValue = StringUtils.split((String)entry, (char)':');
                        if (keyValue.length != 2 || !StringUtils.isNotEmpty((CharSequence)keyValue[0])) continue;
                        HashSet<String> valueSet = new HashSet<String>(Arrays.asList(StringUtils.split((String)keyValue[1], (char)',')));
                        values.put(keyValue[0], valueSet);
                    }
                    break;
                }
                case SINGLE_CHOICE: 
                case MULTIPLE_CHOICE: {
                    HashSet<String> valueSet = new HashSet<String>(Arrays.asList(StringUtils.split((String)value, (char)',')));
                    values.put("values", valueSet);
                    break;
                }
                default: {
                    values.put("values", Collections.singleton(value));
                }
            }
        }
        return values;
    }

    protected boolean hasAlreadyAnswered(String surveyId, UserIdentity user) {
        SurveySession userSession;
        return user != null && StringUtils.isNotBlank((CharSequence)user.getLogin()) && StringUtils.isNotBlank((CharSequence)user.getPopulationId()) && (userSession = this._surveyAnswerDao.getSession(surveyId, user)) != null;
    }

    protected String getMailSubject() {
        return this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.survey", "PLUGINS_SURVEY_SEND_MAIL_SUBJECT"));
    }

    protected String getMailBody(String surveyId, String message, String siteName) {
        Site site = this._siteManager.getSite(siteName);
        String surveyURI = this.getSurveyUri(surveyId, siteName);
        String replacedMessage = StringUtils.replace((String)message, (String)"[link]", (String)surveyURI);
        replacedMessage = StringUtils.replace((String)replacedMessage, (String)"[site]", (String)site.getTitle());
        return replacedMessage;
    }

    protected String getSurveyUri(String surveyId, String siteName) {
        Site site = this._siteManager.getSite(siteName);
        Survey survey = (Survey)this._resolver.resolveById(surveyId);
        Page page = null;
        String xpathQuery = "//element(" + siteName + ", ametys:site)/ametys-internal:sitemaps/" + survey.getLanguage() + "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.survey.service.Display' and ametys:service_parameters/@ametys:surveyId = '" + surveyId + "']";
        AmetysObjectIterable zoneItems = this._resolver.query(xpathQuery);
        AmetysObjectIterator it = zoneItems.iterator();
        if (it.hasNext()) {
            page = (Page)((ZoneItem)it.next()).getZone().getSitemapElement();
        }
        if (page != null) {
            return site.getUrl() + "/" + page.getSitemap().getName() + "/" + page.getPathInSitemap() + ".html";
        }
        return "";
    }
}

