/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.data;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.datasource.AbstractMyBatisDAO;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.survey.data.SurveyAnswer;
import org.ametys.plugins.survey.data.SurveySession;
import org.apache.ibatis.session.SqlSession;

public class SurveyAnswerDao
extends AbstractMyBatisDAO {
    public static final String ROLE = SurveyAnswerDao.class.getName();

    public SurveySession getSession(int sessionId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("id", sessionId);
        try (SqlSession session = this.getSession();){
            SurveySession surveySession = (SurveySession)session.selectOne("SurveyAnswer.getSession", params);
            return surveySession;
        }
    }

    public SurveySession getSession(String surveyId, UserIdentity user) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("surveyId", surveyId);
        params.put("login", user.getLogin());
        params.put("population", user.getPopulationId());
        try (SqlSession sqlSession = this.getSession();){
            SurveySession session;
            List sessions = sqlSession.selectList("SurveyAnswer.getUserSession", params);
            SurveySession surveySession = session = sessions != null && !sessions.isEmpty() ? (SurveySession)sessions.get(0) : null;
            return surveySession;
        }
    }

    public SurveySession getSessionWithAnswers(int sessionId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("id", sessionId);
        try (SqlSession session = this.getSession();){
            SurveySession surveySession = (SurveySession)session.selectOne("SurveyAnswer.getSessionWithAnswers", params);
            return surveySession;
        }
    }

    public int getSessionCount(String surveyId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("surveyId", surveyId);
        try (SqlSession session = this.getSession();){
            int n = (Integer)session.selectOne("SurveyAnswer.getSessionCount", params);
            return n;
        }
    }

    public List<Map<String, Object>> getAllSessionCount() {
        try (SqlSession session = this.getSession();){
            List list = session.selectList("SurveyAnswer.getAllSessionCount");
            return list;
        }
    }

    public List<SurveySession> getSessions() {
        try (SqlSession session = this.getSession();){
            List list = session.selectList("SurveyAnswer.getSessions", (Object)Collections.EMPTY_MAP);
            return list;
        }
    }

    public List<SurveySession> getSessions(String surveyId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("surveyId", surveyId);
        try (SqlSession session = this.getSession();){
            List list = session.selectList("SurveyAnswer.getSessions", params);
            return list;
        }
    }

    public List<SurveySession> getSessionsWithAnswers(String surveyId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("surveyId", surveyId);
        try (SqlSession session = this.getSession();){
            List list = session.selectList("SurveyAnswer.getSessionsWithAnswers", params);
            return list;
        }
    }

    public List<SurveyAnswer> getAnswers(int sessionId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("sessionId", sessionId);
        try (SqlSession session = this.getSession();){
            List list = session.selectList("SurveyAnswer.getAnswers", params);
            return list;
        }
    }

    public void addSession(SurveySession session) throws SQLException {
        try (SqlSession sqlSession = this.getSession();
             Connection connection = sqlSession.getConnection();){
            String stmtId = "SurveyAnswer.addSession" + this.getStatementSuffix(connection);
            sqlSession.insert(stmtId, (Object)session);
            int sessionId = session.getId();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sessionId", sessionId);
            for (SurveyAnswer surveyAnswer : session.getAnswers()) {
                params.put("questionId", surveyAnswer.getQuestionId());
                params.put("answer", surveyAnswer.getValue());
                sqlSession.insert("SurveyAnswer.addAnswer", params);
            }
            sqlSession.commit();
        }
    }

    public void deleteSession(String sessionId) {
        try (SqlSession session = this.getSession();){
            session.delete("SurveyAnswer.deleteAnswers", (Object)sessionId);
            session.delete("SurveyAnswer.deleteSession", (Object)sessionId);
            session.commit();
        }
    }

    public void deleteSessions(String surveyId) {
        try (SqlSession session = this.getSession();){
            session.delete("SurveyAnswer.deleteSurveyAnswers", (Object)surveyId);
            session.delete("SurveyAnswer.deleteSurveySessions", (Object)surveyId);
            session.commit();
        }
    }

    protected String getStatementSuffix(Connection connection) {
        String dbType;
        switch (dbType = ConnectionHelper.getDatabaseType((Connection)connection)) {
            case "mysql": {
                return "-mysql";
            }
            case "postgresql": {
                return "-postgresql";
            }
            case "oracle": {
                return "-oracle";
            }
            case "derby": {
                return "-derby";
            }
        }
        return "";
    }
}

