/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.generators;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.survey.SurveyDateUtils;
import org.ametys.plugins.survey.data.SurveyAnswerDao;
import org.ametys.plugins.survey.generators.SurveysGenerator;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SurveyGenerator
extends SurveysGenerator {
    protected CurrentUserProvider _currentUserProvider;
    protected SurveyAnswerDao _surveyAnswerDao;
    protected CurrentUserProvider _userProvider;
    private RightManager _rightManager;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._surveyAnswerDao = (SurveyAnswerDao)((Object)serviceManager.lookup(SurveyAnswerDao.ROLE));
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        String endingMessage;
        String description;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = this.parameters.getParameter("id", request.getParameter("id"));
        this.contentHandler.startDocument();
        Survey survey = (Survey)this._resolver.resolveById(id);
        GregorianCalendar now = new GregorianCalendar();
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        Date startDate = survey.getStartDate();
        Date endDate = survey.getEndDate();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", survey.getId());
        attrs.addCDATAAttribute("name", survey.getName());
        attrs.addCDATAAttribute("private", String.valueOf(this._surveyDAO.isPrivate(survey)));
        UserIdentity user = this._userProvider.getUser();
        attrs.addCDATAAttribute("canRead", String.valueOf(this._rightManager.hasReadAccess(user, (Object)survey)));
        attrs.addCDATAAttribute("validated", String.valueOf(survey.isValidated()));
        attrs.addCDATAAttribute("status", this._getStatus(startDate, endDate));
        ZonedDateTime reinitDate = survey.getReinitDate();
        if (reinitDate != null) {
            attrs.addCDATAAttribute("reinitDate", SurveyDateUtils.zonedDateTimeToString(reinitDate));
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"survey", (Attributes)attrs);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)survey.getTitle());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)survey.getLabel());
        if (startDate != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"startDate", (String)DateUtils.dateToString((Date)startDate));
        }
        if (endDate != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"endDate", (String)DateUtils.dateToString((Date)endDate));
        }
        if ((description = survey.getDescription()) != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)description);
        }
        if ((endingMessage = survey.getEndingMessage()) != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"endingMessage", (String)endingMessage);
        }
        for (SurveyPage page : survey.getPages()) {
            this.toSAX(page, true, true);
        }
        this.toSAXPicture(survey);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"survey");
        this.contentHandler.endDocument();
    }

    private String _getStatus(Date startDate, Date endDate) {
        GregorianCalendar today = new GregorianCalendar();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        if (startDate != null && startDate.after(today.getTime())) {
            return "coming";
        }
        if (endDate != null && endDate.before(today.getTime())) {
            return "over";
        }
        return "open";
    }
}

