/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.observation;

import javax.jcr.Node;
import javax.jcr.Session;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.survey.dao.SurveyDAO;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.web.cache.AbstractSiteCacheObserver;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public abstract class AbstractSurveyCacheObserver
extends AbstractSiteCacheObserver {
    protected SurveyDAO _surveyDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._surveyDAO = (SurveyDAO)((Object)manager.lookup(SurveyDAO.ROLE));
    }

    protected void _internalObserve(Event event, Site site, Session liveSession) throws Exception {
        Survey survey = this.getSurveyFromEvent(event);
        if (survey != null) {
            for (ModifiableZoneItem zoneItem : this._surveyDAO.getSurveyZoneItems(survey.getSiteName(), survey.getLanguage(), survey.getId())) {
                ModifiablePage page;
                JCRAmetysObject jcrPage;
                Node pageNode;
                SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
                if (!(sitemapElement instanceof JCRAmetysObject) || !(sitemapElement instanceof ModifiablePage) || !liveSession.itemExists((pageNode = (jcrPage = (JCRAmetysObject)(page = (ModifiablePage)sitemapElement)).getNode()).getPath())) continue;
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Survey re-initialized: " + String.valueOf(event) + ", invalidating cache");
                }
                this._cachePolicy.invalidateCacheOnPageModification((Page)page);
            }
        }
    }

    protected Site _getSite(Event event) {
        Survey survey = this.getSurveyFromEvent(event);
        if (survey != null) {
            return survey.getSite();
        }
        return null;
    }

    protected abstract Survey getSurveyFromEvent(Event var1);
}

