/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.repository;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.ametys.cms.data.Binary;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CopiableAmetysObject;
import org.ametys.plugins.repository.data.ametysobject.ModifiableModelLessDataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.survey.repository.SurveyElementFactory;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSurveyElement<F extends SurveyElementFactory>
extends DefaultTraversableAmetysObject<F>
implements CopiableAmetysObject,
ModifiableModelLessDataAwareAmetysObject {
    public static final String PROPERTY_PICTURE = "picture";
    public static final String PROPERTY_PICTURE_TYPE = "ametys-internal:picture-type";
    public static final String PROPERTY_PICTURE_ID = "ametys-internal:picture-id";
    public static final String PROPERTY_PICTURE_ALTERNATIVE = "ametys-internal:picture-alternative";

    public AbstractSurveyElement(Node node, String parentPath, F factory) {
        super(node, parentPath, factory);
    }

    public Binary getExternalPicture() throws AmetysRepositoryException {
        return (Binary)this.getValue(PROPERTY_PICTURE);
    }

    public void setExternalPicture(String mimeType, String filename, InputStream stream) throws AmetysRepositoryException {
        try {
            this.removePictureMetas();
            this.setPictureType("external");
            Binary pic = new Binary();
            pic.setLastModificationDate(ZonedDateTime.now());
            pic.setInputStream(stream);
            pic.setMimeType(mimeType);
            pic.setFilename(filename);
            this.setValue(PROPERTY_PICTURE, pic, "binary");
        }
        catch (IOException | RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the external picture property.", e);
        }
    }

    public String getResourcePictureId() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_PICTURE_ID).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the picture ID property.", (Throwable)e);
        }
    }

    public void setResourcePicture(String resourceId) throws AmetysRepositoryException {
        try {
            this.removePictureMetas();
            this.setPictureType("resource");
            this.getNode().setProperty(PROPERTY_PICTURE_ID, resourceId);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the alternative property.", (Throwable)e);
        }
    }

    public void setNoPicture() throws AmetysRepositoryException {
        try {
            this.setPictureType("");
            this.removePictureMetas();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the alternative property.", (Throwable)e);
        }
    }

    public String getPictureType() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_PICTURE_TYPE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the type property.", (Throwable)e);
        }
    }

    public void setPictureType(String type) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_PICTURE_TYPE, type);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the type property.", (Throwable)e);
        }
    }

    public String getPictureAlternative() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_PICTURE_ALTERNATIVE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the alternative property.", (Throwable)e);
        }
    }

    public void setPictureAlternative(String alternative) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_PICTURE_ALTERNATIVE, alternative);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the alternative property.", (Throwable)e);
        }
    }

    protected void removePictureMetas() throws RepositoryException {
        this.getNode().setProperty(PROPERTY_PICTURE_ID, "");
        this.removeValue(PROPERTY_PICTURE);
    }

    protected void copyPictureTo(AbstractSurveyElement elmt) {
        String pictureType = this.getPictureType();
        if (StringUtils.isBlank((CharSequence)pictureType)) {
            elmt.setNoPicture();
        } else if (pictureType.equals("resource")) {
            String pictureId = this.getResourcePictureId();
            if (StringUtils.isNotBlank((CharSequence)pictureId)) {
                elmt.setResourcePicture(pictureId);
            } else {
                elmt.setNoPicture();
            }
        } else if (pictureType.equals("external")) {
            Binary externalPicture = this.getExternalPicture();
            elmt.setExternalPicture(externalPicture.getMimeType(), externalPicture.getFilename(), externalPicture.getInputStream());
        }
        String pictureAlternative = this.getPictureAlternative();
        if (pictureAlternative != null) {
            elmt.setPictureAlternative(pictureAlternative);
        }
    }

    public ModifiableModelLessDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelLessDataHolder((ModelItemTypeExtensionPoint)((SurveyElementFactory)this._getFactory()).getSurveyElementDataTypeExtensionPoint(), (ModifiableRepositoryData)repositoryData);
    }
}

