/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.repository;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class SurveyEnumerator
extends AbstractLogEnabled
implements Enumerator<String>,
Serviceable,
Contextualizable {
    protected AmetysObjectResolver _resolver;
    protected SiteManager _siteManager;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public Map<String, I18nizableText> getEntries() throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        LinkedHashMap<String, I18nizableText> entries = new LinkedHashMap<String, I18nizableText>();
        String pageId = (String)request.getAttribute("pageId");
        Page page = (Page)this._resolver.resolveById(pageId);
        String siteName = (String)request.getAttribute("siteName");
        String language = page.getSitemapName();
        ModifiableTraversableAmetysObject rootNode = this.getSurveyRootNode(siteName, language);
        try (AmetysObjectIterable surveys = rootNode.getChildren();){
            for (Survey survey : surveys) {
                if (!survey.isValidated()) continue;
                I18nizableText label = new I18nizableText(survey.getLabel());
                entries.put(survey.getId(), label);
            }
        }
        return entries;
    }

    public I18nizableText getEntry(String value) throws Exception {
        Survey survey = (Survey)this._resolver.resolveById(value);
        return new I18nizableText(survey.getLabel());
    }

    protected ModifiableTraversableAmetysObject getSurveyRootNode(String siteName, String lang) throws RepositoryException {
        ModifiableTraversableAmetysObject pluginsNode = this._siteManager.getSite(siteName).getRootPlugins();
        ModifiableTraversableAmetysObject surveyNode = null;
        if (!pluginsNode.hasChild("survey")) {
            surveyNode = (ModifiableTraversableAmetysObject)((ModifiableTraversableAmetysObject)pluginsNode.createChild("survey", "ametys:unstructured")).createChild("ametys:surveys", "ametys:unstructured");
            pluginsNode.saveChanges();
        } else {
            surveyNode = (ModifiableTraversableAmetysObject)pluginsNode.getChild("survey/ametys:surveys");
        }
        if (!surveyNode.hasChild(lang)) {
            surveyNode.createChild(lang, "ametys:unstructured");
            pluginsNode.saveChanges();
        }
        return (ModifiableTraversableAmetysObject)pluginsNode.getChild("survey/ametys:surveys/" + lang);
    }
}

