/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.right;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.core.right.RightsException;
import org.ametys.plugins.core.impl.right.AbstractHierarchicalAccessController;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.survey.dao.SurveyDAO;
import org.ametys.plugins.survey.repository.AbstractSurveyElement;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class SurveyAccessController
extends AbstractHierarchicalAccessController<AmetysObject>
implements Contextualizable {
    protected SiteManager _siteManager;
    protected SurveyDAO _surveyDAO;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._surveyDAO = (SurveyDAO)((Object)manager.lookup(SurveyDAO.ROLE));
    }

    public boolean supports(Object object) {
        return object instanceof AbstractSurveyElement;
    }

    protected Set<AmetysObject> _getParents(AmetysObject object) {
        AmetysObject parent = object.getParent();
        if (this.supports(parent)) {
            return Collections.singleton(parent);
        }
        return null;
    }

    protected boolean ignoreOnHasAnyPermission() {
        return true;
    }

    protected Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> workspacesContexts) {
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        if (siteName != null) {
            Object object;
            block10: {
                Site site = this._siteManager.getSite(siteName);
                AmetysObjectIterable sitemaps = site.getSitemaps();
                try {
                    HashSet<ModifiableTraversableAmetysObject> roots = new HashSet<ModifiableTraversableAmetysObject>();
                    for (Sitemap sitemap : sitemaps) {
                        roots.add(this._surveyDAO.getSurveyRootNode(siteName, sitemap.getName()));
                    }
                    object = roots;
                    if (sitemaps == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (sitemaps != null) {
                            try {
                                sitemaps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RepositoryException | AmetysRepositoryException e) {
                        this.getLogger().error("Failed to convert workspace to root right contexts. The controller will be ignored", e);
                        return null;
                    }
                }
                sitemaps.close();
            }
            return object;
        }
        return null;
    }

    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        Map<String, I18nizableText> params = Map.of("title", this.getObjectLabel(object));
        return new I18nizableText("plugin.survey", "PLUGINS_SURVEY_ACCESS_CONTROLLER_CONTEXT_LABEL", params);
    }

    public I18nizableText getObjectLabel(Object object) throws RightsException {
        if (object instanceof AbstractSurveyElement) {
            AbstractSurveyElement element = (AbstractSurveyElement)((Object)object);
            Survey survey = null;
            if (element instanceof SurveyPage) {
                SurveyPage page = (SurveyPage)element;
                survey = page.getSurvey();
            } else if (element instanceof Survey) {
                Survey s;
                survey = s = (Survey)element;
            } else if (element instanceof SurveyQuestion) {
                SurveyQuestion q = (SurveyQuestion)element;
                survey = q.getSurvey();
            }
            if (survey != null) {
                return new I18nizableText(survey.getLabel());
            }
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return new I18nizableText("plugin.survey", "PLUGINS_SURVEY_ACCESS_CONTROLLER_CONTEXT_CATEGORY");
    }
}

