<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:math="java.lang.Math" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              exclude-result-prefixes="ametys i18n math">

 	<xsl:import href="workspace:web://stylesheets/variables.xsl"/> 
	<xsl:import href="plugin:survey://stylesheets/survey2html.xsl"/>
	
	<xsl:param name="actionUrl"/>
	
	<xsl:template match="/">
		<xml>
			<style type="text/css">
				.q {
					font-weight: bold;
				}
				.input {
					float: left;
				}
				.question {
					clear: left;
				}
				.question fieldset {
					border: 0 none;
					padding: 0;
				}
				.field-end {clear: both;}
				.question .label input,
				.question .input input,
				.question .input textarea
				{
				    border: 1px solid #AAAAAA;
				    padding: 5px;
				}
				.question .input textarea {
					height: 120px;
					width: 400px;
				}
				.question input.text {
					width: 400px;
				}
				.question .label input {
					width: 200px;
				}
				.buttons {
					clear: left;
					text-align: left;
				}
			</style>
			
	   		<h1><xsl:value-of select="survey/title"/></h1>
			<xsl:call-template name="view"/>
		</xml>
	</xsl:template>
		
	<xsl:template name="view">
		<xsl:param name="level">2</xsl:param>
	
		<xsl:if test="survey/description != ''">
			<p class="survey-hint">
				<xsl:call-template name="text.nl2br">
                	<xsl:with-param name="input"><xsl:value-of select="survey/description"/></xsl:with-param>
                </xsl:call-template>
            </p>    
		</xsl:if>
			
		<p class="mandatory-hint" id="survey-{$uniqueId}-mandatory-hint">
       		<i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_LABEL" i18n:catalogue="plugin.web"/>
     	</p>
       
		<form method="post" action="{$actionUrl}">
			<div>
                <input type="hidden" name="surveyId" value="{survey/@id}"/>
                
				<xsl:apply-templates select="survey/page">
					<xsl:with-param name="level" select="$level"/>
				</xsl:apply-templates>
				
				<xsl:if test="survey/endingMessage != ''">
					<div class="end" id="survey-{$uniqueId}-end-text">
						<p class="survey-hint">
							<xsl:call-template name="text.nl2br">
			                	<xsl:with-param name="input"><xsl:value-of select="survey/endingMessage"/></xsl:with-param>
			                </xsl:call-template>
			           	</p>
	               </div>    
				</xsl:if>
				
				<div class="buttons">
					<xsl:call-template name="submit-button"/>
				</div>
			</div>
		</form>
	</xsl:template>
	
	<xsl:template match="page">
		<xsl:param name="level"/>
	
		<xsl:variable name="isFirstPage" select="position() = 1"/>
		<xsl:variable name="isLastPage" select="position() = last()"/>

		<div id="survey-{$uniqueId}-page-{position()}">
			<xsl:if test="title != ''">
				<xsl:element name="h{$level}">
					<xsl:attribute name="class">survey-page-title</xsl:attribute>
					<xsl:value-of select="title"/>
				</xsl:element>
			</xsl:if>
			
			<xsl:if test="description != ''">
				<p class="survey-page-hint">
					<xsl:call-template name="text.nl2br">
	                	<xsl:with-param name="input"><xsl:value-of select="description"/></xsl:with-param>
	                </xsl:call-template>
				</p>
			</xsl:if>
			
			<xsl:apply-templates select="question"/>
			
			<xsl:if test="branches/page-rule">
				<p class="rules">
					<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_PAGE_RULE_START"/>

					<xsl:variable name="page" select="branches/page-rule/@page"/>
					<xsl:choose>
						<xsl:when test="branches/page-rule/@type = 'JUMP'">
							 <a href="#survey-{$uniqueId}-{//page[@id = $page]/@name}">
							 	<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_JUMP_TO_START"/><xsl:value-of select="count(//page[@id = $page]/preceding::question) +1"/>
							 </a>
							 <i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_JUMP_TO_END"/>
						</xsl:when>
						<xsl:when test="branches/page-rule/@type = 'FINISH'">
							<a href="#survey-{$uniqueId}-end">
								<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_FINISH_START"/>
							</a>
							<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_FINISH_END"/>
						</xsl:when>
					</xsl:choose>
				</p>
			</xsl:if>
		</div>
	</xsl:template>		
	
	<xsl:template match="question[@type = 'MULTILINE_FREE_TEXT']">
		<div class="question" id="survey-{$uniqueId}-q-{@name}">
			<div class="field">
				<div class="label">
					<label for="{@name}_{$uniqueId}">
						<span class="q">Q.<xsl:value-of select="count(preceding::question) + 1"/> - </span><xsl:value-of select="title"/>
						<xsl:if test="@mandatory = 'true'"><span class="mandatory-marker"><xsl:text> </xsl:text><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span></xsl:if>
					</label>
				</div>
				<div class="input">	
					<textarea name="{@name}" id="{@name}_{$uniqueId}" rows="3" cols="10"><xsl:text> </xsl:text></textarea>
				</div>
				<div class="field-end"/>
			</div>
		</div>
	</xsl:template>	
	
</xsl:stylesheet>