<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="exsl resolver">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service:survey://stylesheets/survey2html.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">survey</xsl:variable>
    <xsl:variable name="is-empty" select="false()"/> 
    <xsl:variable name="common-service-name-id">service-survey</xsl:variable>    
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="survey/title/text()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="head-scripts"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="survey/title/text()"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:variable name="raw-is-title-visible">
	        <xsl:call-template name="common-service-body-nonempty-content-title-content">
	            <xsl:with-param name="title" select="survey/title/text()"/>
	        </xsl:call-template>    
        </xsl:variable>
                    
        <xsl:variable name="is-title-visible" select="string-length($raw-is-title-visible) &gt; 0"/>
        
        <xsl:choose>
            <xsl:when test="survey/@canRead != 'true'">
                <xsl:call-template name="survey-can-not-read"/>
            </xsl:when>
            <xsl:when test="survey/@status != 'open'">
                <xsl:call-template name="survey-opening-dates">
                    <xsl:with-param name="status" select="survey/@status"></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="view">
                    <xsl:with-param name="level">
                        <xsl:choose>
                            <xsl:when test="$is-title-visible">2</xsl:when>
                            <xsl:otherwise>1</xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
        
    <xsl:template name="survey-can-not-read">
        <i18n:text i18n:key="PLUGINS_SURVEY_PRIVATE_SCHEDULE"/>
    </xsl:template>
    
    <xsl:template name="survey-opening-dates">
        <xsl:param name="status"/>
        
        <div class="survey-opening-dates">
            <xsl:choose>
                <xsl:when test="$status = 'over'">
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_SURVEY_SCHEDULE_OVER_END_DATE"/>
                        <i18n:param><i18n:date pattern="long" src-pattern="yyyy-MM-dd'T'HH:mm:ss"><xsl:value-of select="survey/endDate"/></i18n:date></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="survey/startDate and survey/endDate">
                            <i18n:translate>
                                <i18n:text i18n:key="PLUGINS_SURVEY_SCHEDULE_COMING_START_END_DATE"/>
                                <i18n:param><i18n:date pattern="long" src-pattern="yyyy-MM-dd'T'HH:mm:ss"><xsl:value-of select="survey/startDate"/></i18n:date></i18n:param>
                                <i18n:param><i18n:date pattern="long" src-pattern="yyyy-MM-dd'T'HH:mm:ss"><xsl:value-of select="survey/endDate"/></i18n:date></i18n:param>
                            </i18n:translate>
                        </xsl:when>
                        <xsl:when test="survey/startDate">
                            <i18n:translate>
                                <i18n:text i18n:key="PLUGINS_SURVEY_SCHEDULE_COMING_START_DATE"/>
                                <i18n:param><i18n:date pattern="long" src-pattern="yyyy-MM-dd'T'HH:mm:ss"><xsl:value-of select="survey/startDate"/></i18n:date></i18n:param>
                            </i18n:translate>
                        </xsl:when>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>            
        </div>
    </xsl:template>
        
</xsl:stylesheet>
