/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Survey context for profile assignments.
 */
Ext.define('Ametys.plugins.survey.SurveyRightAssignmentContext', {
    extend: 'Ametys.plugins.coreui.profiles.AbstractRightAssignmentContext',
    
    /**
     * @private
     * @property {Ametys.plugins.survey.SurveyTree} _tree The survey tree
     */
    
    getComponent: function()
    {
        this._tree = Ext.create('Ametys.plugins.survey.SurveyTree', {
        	rootVisible: false,
        	surveyOnly: true,
        	listeners: {
        		'selectionchange': Ext.bind(this._onSelectionChanged, this)
        	}
        });
        return this._tree;
    },
    
    initialize: function()
    {
    	this._tree.refreshNode(null, false, Ext.bind(this._refreshCb, this));
    },
    
    isSupported: function (message)
    {
    	return message.getTargets(Ametys.message.MessageTarget.SURVEY).length > 0;
    },
    
    initContext: function (message)
    {
    	this._langToSelect = null;
    	this._surveyIdToSelect = null;
    	
    	var surveyTarget = message.getTarget(Ametys.message.MessageTarget.SURVEY);
    	if (surveyTarget != null)
    	{
    		this._surveyIdToSelect = surveyTarget.getParameters().id;
    		this._langToSelect = surveyTarget.getParameters().lang;
    	}
    },
    
    /**
     * Listens when a language is changed.
     * @param {Ext.form.field.Field} field The field
     * @param {Object} newValue The new language value.
     * @param {Object} oldValue The original value.
     * @private
     */
    _onChangeLang: function(field, newValue, oldValue)
    {
        // Reload sitemap
    	this._pathToSelect = null;
    	this._sitemapToSelect = null;
    	
        this._tree.setSitemapName(newValue, Ext.bind(this._refreshCb, this));
    },
    
    /**
     * @private
     * Callback function after (re)loading the tree
     */
    _refreshCb: function()
    {
    	if (this._surveyIdToSelect != null)
    	{
    		var node = this._tree.getStore().getNodeById(this._surveyIdToSelect);
    		this._tree.getSelectionModel().select(node);
    	}
    	else if (this._langToSelect != null)
    	{
    		// TODO select language
    	}
    	else
    	{
    		// Select root node
    		this._tree.getSelectionModel().select(0);
    	}
    },
    
    /**
     * @private
     * Listener when the selection in the tree has changed
     * @param {Ext.selection.Model} model The selection model
     * @param {Ext.data.Model[]} selected The selected records
     */
    _onSelectionChanged: function(model, selected)
    {
        // Check it is not too soon to fire the event (if we do not loaded the root node yet for example)
        if (selected.length > 0 && !selected[0].isRoot())
        {
    		var object = selected[0].get('id'),
            title = selected[0].get('label');
        
    		var hintTextContext ="{{i18n PLUGINS_SURVEY_SURVEYACCESS_CONTEXT_HINT_SURVEY}} <b>" + title + "</b>";
            
            this._changeObjectContext(object, hintTextContext, false);
        }
        else
        {
        	this._changeObjectContext(null);
        }
    }
});
