/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button pressed only if a page redirection is set to the current survey selection.
 * @private
 */
Ext.define('Ametys.plugins.survey.controller.Export2HtmlActionController', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
	constructor: function(config)
	{
		this.callParent(arguments);
		
		this._enableOnValidationOnly = this.getInitialConfig('enable-on-validation-only');
		
		Ametys.message.MessageBus.on(Ametys.message.Message.WORKFLOW_CHANGED, this._onWorkflowChanged, this);
	},
	
	/**
	 * Listener on workflow changing message.
	 * @param {Ametys.message.Message} message The message.
	 * @private
	 */
	_onWorkflowChanged: function (message)
	{
		var target = message.getTarget(Ametys.message.MessageTarget.SURVEY);
		if (target != null && target.getParameters().id == this._currentSurveyId)
		{
			Ametys.cms.survey.SurveyDAO.isOnline([this._currentSurveyId], Ext.bind(this._isOnlineCb, this), {scope: this})
		}
	},
	
	/**
	 * Listener when the selection has changed.
	 * @param {Ametys.message.Message} message The edition message.
	 * @private
	 */
	_onSelectionChanged: function (message)
	{
		this.callParent(arguments);// call the method form the CommonController superclass
		
		var target = message.getTarget(Ametys.message.MessageTarget.SURVEY);
		if (target != null)
		{
			this._currentSurveyId = target.getParameters().id;
			
			Ametys.cms.survey.SurveyDAO.isOnline([this._currentSurveyId], Ext.bind(this._isOnlineCb, this), {scope: this});
		}
		else
		{
			this._currentSurveyId = null;
			this.disable();
		}
	},
	
	/**
	 * @private
	 * Callback arguments after retrieving the online/valid status.
	 * Determines if the survey is validated and toggle or not this controller.
	 * @param {Object} response The text response provided by the {@link Ametys.data.ServerComm}
	 * @param {Object} args the callback arguments
	 */
	_isOnlineCb: function(response, args)
	{
		var isValid = response.isValid == "true";
		if (isValid)
		{
			this.enable();
		}
		else
		{
			var additionalDescription = "<br/><br/>" + this.getInitialConfig('disable-description');
			this.setAdditionalDescription(additionalDescription);
			this.disable();
		}
	}
	
});