/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button enabled only if the current survey selection is private, valid and online.
 * @private
 */
Ext.define('Ametys.plugins.survey.controller.InvitationsActionController', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
	constructor: function(config)
	{
		this.callParent(arguments);
		
		Ametys.message.MessageBus.on(Ametys.message.Message.WORKFLOW_CHANGED, this._onWorkflowChanged, this);
	},
	
	/**
	 * Listener on workflow changing message.
	 * @param {Ametys.message.Message} message The message.
	 * @private
	 */
	_onWorkflowChanged: function (message)
	{
		var target = message.getTarget(Ametys.message.MessageTarget.SURVEY);
		if (target != null && target.getParameters().id == this._currentSurveyId)
		{
			this.serverCall ('getStatus', [this._currentSurveyId], Ext.bind (this._getStatusCb, this), { errorMessage: true, refreshing: true });
		}
	},
	
	/**
	 * Listener when the selection has changed.
	 * @param {Ametys.message.Message} message The edition message.
	 * @private
	 */
	_onSelectionChanged: function (message)
	{
		this.callParent(arguments);// call the method form the CommonController superclass
		
		var target = message.getTarget(Ametys.message.MessageTarget.SURVEY);
		if (target != null)
		{
			this._currentSurveyId = target.getParameters().id;
			
			this.serverCall ('getStatus', [this._currentSurveyId], Ext.bind (this._getStatusCb, this), { errorMessage: true, refreshing: true });
		}
		else
		{
			this._currentSurveyId = null;
			this.disable();
		}
	},
	
	/**
	 * @private
	 * Callback arguments after retrieving the survey status.
	 * @param {Object} response The text response provided by the {@link Ametys.data.ServerComm}
	 * @param {Object} args The callback arguments
	 */
	_getStatusCb: function(response, args)
	{
		this.setDescription(response.description);
		
		if (response.status == "all-right")
		{
			this.enable();
		}
		else
		{
			this.disable();
		}
	}
	
});