/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button for the 'print survey' feature.
 * @private
 */
Ext.define('Ametys.plugins.survey.controller.OpenSurveyActionController', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
	constructor: function(config)
	{
		this.callParent(arguments);
	},
	
	/**
	 * Listener when the selection has changed.
	 * @param {Ametys.message.Message} message The edition message.
	 * @private
	 */
	_onSelectionChanged: function (message)
	{
		this.callParent(arguments);// call the method form the CommonController superclass
		
		var target = message.getTarget(Ametys.message.MessageTarget.SURVEY);
		if (target != null)
		{
			this._currentSurveyId = target.getParameters().id;
			
			var tool = Ametys.tool.ToolsManager.getTool('uitool-survey-preview$' + this._currentSurveyId);
			if (!tool)
			{
				this.setAdditionalDescription(this.getInitialConfig('not-open-description'));
				this.disable();
			}
			else
			{
				this.setDescription(this.getInitialConfig('description'));
				this.setAdditionalDescription("");
				this.enable();
			}
		}
		else
		{
			this._currentSurveyId = null;
			this.disable();
		}
	}
	
});