<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:param name="contextPath" />
    <xsl:param name="cms-context" />
    <xsl:param name="plugin" />
    <xsl:param name="site" />
    <xsl:param name="locale" />
    
    <xsl:variable name="decimal-separator">
        <xsl:choose>
            <xsl:when test="$locale = 'fr' or $locale ='fr_FR'">,</xsl:when>
            <xsl:otherwise>.</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template match="/ActionResult">
        <html>
            <head />
            <body>
                <div>
                    <i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_GLOBAL_TEXT_1"/>
                    <xsl:value-of select="sessions" />
                    <i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_GLOBAL_TEXT_2"/>
                </div>
                <br />
                
                <xsl:apply-templates select="questions/questions"/>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="questions">
        <table>
            <thead>
                <xsl:choose>
                    <xsl:when test="type = 'FREE_TEXT' or type='MULTILINE_FREE_TEXT' or type = 'SINGLE_CHOICE' or type='MULTIPLE_CHOICE'">
                        <xsl:call-template name="question-simple-header"/>
                    </xsl:when>
                    <xsl:when test="type = 'SINGLE_MATRIX' or type='MULTIPLE_MATRIX'">
                        <xsl:call-template name="question-matrix-header"/>
                    </xsl:when>
                </xsl:choose>
            </thead>
            <tbody>
               <xsl:choose>
                   <xsl:when test="type = 'FREE_TEXT' or type='MULTILINE_FREE_TEXT'">
                       <xsl:call-template name="question-text"/>
                   </xsl:when>
                   <xsl:when test="type = 'SINGLE_CHOICE' or type='MULTIPLE_CHOICE'">
                       <xsl:apply-templates select="options/options/choices/choices" mode="question-choice" />
                   </xsl:when>
                   <xsl:when test="type = 'SINGLE_MATRIX' or type='MULTIPLE_MATRIX'">
                       <xsl:call-template name="question-matrix" />
                   </xsl:when>
               </xsl:choose>
            </tbody>
        </table>
        
        <!-- Empty row between tables -->
        <br />
    </xsl:template>
    
    <xsl:template name="question-header-title">
        <th style="text-align: left">
            <i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_QUESTION_PANEL_TITLE_1"/><xsl:value-of select="position()" /><i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_QUESTION_PANEL_TITLE_2"/>
            <xsl:value-of select="title" />
        </th>
    </xsl:template>
    
    <xsl:template name="question-simple-header">
        <tr>
            <xsl:call-template name="question-header-title" />
            <td>
                <i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_CHOICE_COUNT"/>
            </td>
            <td>
                <i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_CHOICE_PERCENT"/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="question-matrix-header">
        <tr>
            <xsl:call-template name="question-header-title" />
            <xsl:apply-templates select="options/options[1]/choices/choices" mode="header" />
        </tr>
    </xsl:template>
    
    <xsl:template match="choices" mode="header">
        <th colspan="2">
            <xsl:value-of select="label" />
        </th>
    </xsl:template>
    
    <xsl:template name="question-text">
        <tr>
            <td>
                <i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_ANSWERED" />
            </td>
            <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="options/options/choices/choices[value = 'answered']/count" /></xsl:call-template>
        </tr>
        <tr>
            <td>
                <i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_NOT_ANSWERED" />
            </td>
            <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="options/options/choices/choices[value = 'empty']/count" /></xsl:call-template>
        </tr>
    </xsl:template>
    
    <xsl:template match="choices" mode="question-choice">
        <tr>
            <td>
                <xsl:value-of select="label" />
            </td>
            <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="count" /></xsl:call-template>
        </tr>
    </xsl:template>
    
    <xsl:template name="question-matrix">
        <xsl:for-each select="options/options">
            <tr>
                <td>
                    <xsl:value-of select="label" />
                </td>
                <xsl:for-each select="choices/choices">
                    <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="count" /></xsl:call-template>
                </xsl:for-each>
            </tr>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="output-choice-values">
        <xsl:param name="count" />
        
        <td style='mso-number-format:"0"'>
            <xsl:value-of select="$count" />
        </td>
        <td style='mso-number-format:"Percent"'>
            <xsl:value-of select="translate($count div /ActionResult/sessions, '.', $decimal-separator)" />
        </td>
    </xsl:template>
    
</xsl:stylesheet>
