<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:math="java.lang.Math" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              extension-element-prefixes="math ametys resolver">

	<xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
	<xsl:import href="view://stylesheets/utils.xsl"/>
	
    <xsl:param name="preview">false</xsl:param>
	
	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
	<xsl:variable name="renderingContext" select="ametys:renderingContext()"/>
	
	<xsl:template name="head-scripts">
		<script type="text/javascript">
			try
			{
				survey_precedePages;
			}
			catch (e)
			{
				survey_precedePages = {};
			}
			
			survey_precedePages['<xsl:value-of select="$uniqueId"/>'] = [];

			<xsl:for-each select="survey//page">
				function checkForm_<xsl:value-of select="$uniqueId"/>_<xsl:value-of select="position()"/>()
				{
					survey_reset_errors('<xsl:value-of select="$uniqueId"/>');
					
					var errors = [];
					
					<xsl:if test="$preview != 'true'">
					// Check mandatory fields
					<xsl:apply-templates select="question[@mandatory = 'true']" mode="check-mandatory"/>
					</xsl:if>
					// Check RegExp
					<xsl:apply-templates select="question[@type = 'FREE_TEXT' and regexp and regexp != '']" mode="check-regexp"/>
					
					return errors;
				}
			</xsl:for-each>
			
			<xsl:for-each select="survey//page">
				function branches_<xsl:value-of select="$uniqueId"/>_<xsl:value-of select="position()"/>()
				{
					if (1 == 0)
					{
						// Nothing
					}<xsl:for-each select="branches/rule">
					else if ($j('#<xsl:value-of select="concat(@name, '_', @value)"/>').get(0).checked)
					{<xsl:if test="@type = 'FINISH'">
						// Finish survey
						return 0;
					</xsl:if><xsl:if test="@type = 'JUMP'"><xsl:variable name="pageId" select="@page"/>
						// Returns position of next page
						return (<xsl:value-of select="count(//page[@id = $pageId]/preceding::page)"/> + 1);</xsl:if>
					}</xsl:for-each>
					<xsl:if test="branches/page-rule">
					else
					{<xsl:if test="branches/page-rule/@type = 'FINISH'">
						// Finish survey
						return 0;
					</xsl:if><xsl:if test="branches/page-rule/@type = 'JUMP'"><xsl:variable name="pageId" select="branches/page-rule/@page"/>
						// Returns position of next page
						return (<xsl:value-of select="count(//page[@id = $pageId]/preceding::page)"/> + 1);</xsl:if>
					}</xsl:if>
					// No rule, go to next page
					return -1;
				}
			</xsl:for-each>
			
			<xsl:call-template name="survey-cookies"/>
		</script>
		
        <xsl:choose>
            <xsl:when test="$lang != ''">
                <script src="{$uri-prefix}/plugins/survey/resources/js/survey.{$lang}.js" type="text/javascript"/>
            </xsl:when>
            <xsl:otherwise>
        		<script src="{$uri-prefix}/plugins/survey/resources/js/survey.js" type="text/javascript"/>
            </xsl:otherwise>
        </xsl:choose>
		
	</xsl:template>
	
	<xsl:template name="survey-cookies">
		<!-- Go to the page pre-selected in the cookies and fill the form -->
		<xsl:if test="$renderingContext = 'front'">
			$j(document).ready(function()
			{
			     surveyCookiePath = "<xsl:value-of select="ametys:siteUriPrefix()"/>";
			     survey_fill_form('<xsl:value-of select="survey/@id"/>', '<xsl:value-of select="$uniqueId"/>', <xsl:value-of select="count(survey/page) + 1"/>);
                 
                 $j("form#survey-<xsl:value-of select="$uniqueId"/>-form :input").each(function(){
					 var input = $j(this);
					 var onEvent_debounced = survey_debounce(function() {
					   survey_save_form_values ('<xsl:value-of select="survey/@id" />', '<xsl:value-of select="$uniqueId" />')
				     }, 200);
					 input.on('input', onEvent_debounced);
                     input.on('change', onEvent_debounced);
                     input.on('blur', onEvent_debounced);
				});
            });
           </xsl:if>
	</xsl:template>
	
	<xsl:template name="view">
		<xsl:param name="level">2</xsl:param>
	
		<div id="survey-{$uniqueId}">
			<xsl:call-template name="start-page"/>
				
			<xsl:call-template name="form-hint"/>
        
			<form id="survey-{$uniqueId}-form" method="post" action="{$site-uri-prefix}/{$lang}/_plugins/survey/{$template}/finish.html">
				<div>
	                <input type="hidden" name="surveyId" value="{survey/@id}"/>
	                
					<xsl:apply-templates select="survey/page">
						<xsl:with-param name="level" select="$level"/>
					</xsl:apply-templates>
					
					<!-- The finish page has to exist in case of rule of type "Finish survey" -->
					<xsl:call-template name="finish-page"/>
				</div>
			</form>
		</div>
	</xsl:template>
	
	<xsl:template name="form-hint">
		<p class="mandatory-hint" id="survey-{$uniqueId}-mandatory-hint">
       		<i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_LABEL" i18n:catalogue="plugin.web"/>
     	</p>
     	<script type="text/javascript">
     		$j("#survey-<xsl:value-of select="$uniqueId"/>-mandatory-hint").hide();
     	</script>
	</xsl:template>

	<xsl:template name="start-page">
		<div class="start" id="survey-{$uniqueId}-start-page">
			<xsl:call-template name="picture" >
                <xsl:with-param name="class" select="'survey-picture'" />
                <xsl:with-param name="picture" select="survey/picture" />
                <xsl:with-param name="alt" select="survey/pictureAlternative" />
                <xsl:with-param name="idObject" select="survey/@id" />
            </xsl:call-template>  

			<xsl:if test="survey/description != ''">
				<p class="survey-hint">
					<xsl:call-template name="text.nl2br">
	                	<xsl:with-param name="input"><xsl:value-of select="survey/description"/></xsl:with-param>
	                </xsl:call-template>
                </p>    
			</xsl:if>
			
			<script type="text/javascript">
				<xsl:if test="$preview = 'false'">
	                if (survey_alreadyTaken("<xsl:value-of select="survey/@id"/>", "<xsl:value-of select="survey/@reinitDate"/>"))
	                {
	                    document.write('&lt;p class="alreadyTaken"&gt;');
	                    document.write('<i18n:text i18n:key="PLUGINS_SURVEY_RENDER_ALREADY_TAKEN"/>');
	                    document.write('&lt;/p&gt;');
	                }
	                else
				</xsl:if>
                {
                    document.write('&lt;div class="buttons"&gt;');
	                	<xsl:call-template name="common-utils-jswrite-input-submit">
	                		<xsl:with-param name="class-name">start</xsl:with-param>
	                		<xsl:with-param name="i18nkey">PLUGINS_SURVEY_PAGE_FORM_BEGIN_BUTTON</xsl:with-param>
	                		<xsl:with-param name="onclick">try { survey_begin('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="survey/@id" />', '<xsl:value-of select="$renderingContext" />'); } catch(e) {} return false;</xsl:with-param>
	                	</xsl:call-template>
                    document.write('&lt;/div&gt;');
                }
			</script>
		</div>
	</xsl:template>
		
	<xsl:template name="finish-page">
		<div id="survey-{$uniqueId}-page-{count(survey/page) + 1}">
			<a name="survey-{$uniqueId}-end"/>
			
			<xsl:if test="survey/endingMessage != ''">
				<div class="end" id="survey-{$uniqueId}-end-text">
					<p class="survey-hint">
						<xsl:call-template name="text.nl2br">
		                	<xsl:with-param name="input"><xsl:value-of select="survey/endingMessage"/></xsl:with-param>
		                </xsl:call-template>
		           	</p>
               </div>    
			</xsl:if>
		
			<div class="buttons">
				<script type="text/javascript">
	               	<xsl:call-template name="common-utils-jswrite-input-submit">
	               		<xsl:with-param name="class-name">previous</xsl:with-param>
	               		<xsl:with-param name="i18nkey">PLUGINS_SURVEY_PAGE_FORM_PRECEDE_BUTTON</xsl:with-param>
	               		<xsl:with-param name="onclick">try { survey_previouspage('<xsl:value-of select="$uniqueId"/>', <xsl:value-of select="count(survey/page) + 1"/>, '<xsl:value-of select="survey/@id" />', '<xsl:value-of select="$renderingContext" />'); } catch(e) {} return false;</xsl:with-param>
	               	</xsl:call-template>
	            </script>
	
				<xsl:call-template name="submit-button"/>
			</div> 
		</div>
		<script type="text/javascript">
			$j("#survey-<xsl:value-of select="$uniqueId"/>-page-<xsl:value-of select="count(survey/page) + 1"/>").hide();
		</script>
	</xsl:template>
	
	<xsl:template name="submit-button">
		<xsl:choose>
			<xsl:when test="$preview = 'true'">
				<xsl:call-template name="common-utils-input-submit">
					<xsl:with-param name="class-name">submit</xsl:with-param>
					<xsl:with-param name="i18nkey">PLUGINS_SURVEY_PAGE_FORM_FINISH_BUTTON</xsl:with-param>
					<xsl:with-param name="disabled" select="true()"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="common-utils-input-submit">
					<xsl:with-param name="class-name">submit</xsl:with-param>
					<xsl:with-param name="i18nkey">PLUGINS_SURVEY_PAGE_FORM_FINISH_BUTTON</xsl:with-param>
					<xsl:with-param name="onclick">try { survey_end('<xsl:value-of select="$uniqueId" />', <xsl:value-of select="count(survey/page)"/>, '<xsl:value-of select="survey/@id" />', '<xsl:value-of select="$renderingContext" />'); } catch(e) {} return false;</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="page">
		<xsl:param name="level"/>
	
		<xsl:variable name="isFirstPage" select="position() = 1"/>
		<xsl:variable name="isLastPage" select="position() = last()"/>

		<div id="survey-{$uniqueId}-page-{position()}">
			<a name="survey-{$uniqueId}-{@name}"/>
			<xsl:if test="title != ''">
				<xsl:element name="h{$level}">
					<xsl:attribute name="class">survey-page-title</xsl:attribute>
					<xsl:value-of select="title"/>
				</xsl:element>
			</xsl:if>
			
			<xsl:call-template name="picture" >
                <xsl:with-param name="class" select="'survey-page-picture'" />
                <xsl:with-param name="picture" select="picture" />
                <xsl:with-param name="alt" select="pictureAlternative" />
                <xsl:with-param name="idObject" select="@id" />
            </xsl:call-template>  
            
			<xsl:if test="description != ''">
				<p class="survey-page-hint">
					<xsl:call-template name="text.nl2br">
	                	<xsl:with-param name="input"><xsl:value-of select="description"/></xsl:with-param>
	                </xsl:call-template>
				</p>
			</xsl:if>
			
			<xsl:apply-templates select="question"/>
			
			<xsl:choose>
				<xsl:when test="$isLastPage and normalize-space(../endingMessage) = ''">
					<script type="text/javascript">	
						document.write("&lt;div class=\"buttons\"&gt;");
						<xsl:if test="not($isFirstPage)">
			               	<xsl:call-template name="common-utils-jswrite-input-submit">
			               		<xsl:with-param name="class-name">previous</xsl:with-param>
			               		<xsl:with-param name="i18nkey">PLUGINS_SURVEY_PAGE_FORM_PRECEDE_BUTTON</xsl:with-param>
			               		<xsl:with-param name="onclick">try { survey_previouspage('<xsl:value-of select="$uniqueId"/>', <xsl:value-of select="position()"/>, '<xsl:value-of select="../@id" />', '<xsl:value-of select="$renderingContext" />'); } catch(e) {} return false;</xsl:with-param>
			               	</xsl:call-template>
				        </xsl:if>
			
						<xsl:choose>
							<xsl:when test="$preview = 'true'">
								<xsl:call-template name="common-utils-jswrite-input-submit">
									<xsl:with-param name="class-name">submit</xsl:with-param>
									<xsl:with-param name="i18nkey">PLUGINS_SURVEY_PAGE_FORM_FINISH_BUTTON</xsl:with-param>
									<xsl:with-param name="disabled" select="true()"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="common-utils-jswrite-input-submit">
									<xsl:with-param name="class-name">submit</xsl:with-param>
									<xsl:with-param name="i18nkey">PLUGINS_SURVEY_PAGE_FORM_FINISH_BUTTON</xsl:with-param>
									<xsl:with-param name="onclick">try { survey_end('<xsl:value-of select="$uniqueId"/>', <xsl:value-of select="position()"/>, '<xsl:value-of select="../@id" />', '<xsl:value-of select="$renderingContext" />'); } catch(e) {} return false;</xsl:with-param>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
						document.write("&lt;/div&gt;");
					</script>
				</xsl:when>
				<xsl:otherwise>
					<script type="text/javascript">
						document.write("&lt;div class=\"buttons\"&gt;");
						<xsl:if test="not($isFirstPage)">
		                	<xsl:call-template name="common-utils-jswrite-input-submit">
		                		<xsl:with-param name="class-name">previous</xsl:with-param>
		                		<xsl:with-param name="i18nkey">PLUGINS_SURVEY_PAGE_FORM_PRECEDE_BUTTON</xsl:with-param>
		                		<xsl:with-param name="onclick">try { survey_previouspage('<xsl:value-of select="$uniqueId"/>', <xsl:value-of select="position()"/>, '<xsl:value-of select="../@id" />', '<xsl:value-of select="$renderingContext" />'); } catch(e) {} return false;</xsl:with-param>
		                	</xsl:call-template>
						</xsl:if>
		               	<xsl:call-template name="common-utils-jswrite-input-submit">
		               		<xsl:with-param name="class-name">next</xsl:with-param>
		               		<xsl:with-param name="i18nkey">PLUGINS_SURVEY_PAGE_FORM_NEXT_BUTTON</xsl:with-param>
		               		<xsl:with-param name="onclick">try { survey_nextpage('<xsl:value-of select="$uniqueId"/>', <xsl:value-of select="position()"/>, <xsl:value-of select="count(../page) + 1"/>, '<xsl:value-of select="../@id" />', '<xsl:value-of select="$renderingContext" />'); } catch(e) {} return false;</xsl:with-param>
		               	</xsl:call-template>
						document.write("&lt;/div&gt;");
					</script>
				</xsl:otherwise>
			</xsl:choose>
			
			<xsl:if test="branches/page-rule">
				<noscript>
					<p class="rules">
						<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_PAGE_RULE_START"/>

						<xsl:variable name="page" select="branches/page-rule/@page"/>
						<xsl:choose>
							<xsl:when test="branches/page-rule/@type = 'JUMP'">
								 <a href="#survey-{$uniqueId}-{//page[@id = $page]/@name}">
								 	<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_JUMP_TO_START"/><xsl:value-of select="count(//page[@id = $page]/preceding::question) +1"/>
								 </a>
								 <i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_JUMP_TO_END"/>
							</xsl:when>
							<xsl:when test="branches/page-rule/@type = 'FINISH'">
								<a href="#survey-{$uniqueId}-end">
									<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_FINISH_START"/>
								</a>
								<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_FINISH_END"/>
							</xsl:when>
						</xsl:choose>
					</p>
				</noscript>
			</xsl:if>
		</div>
		
		<script type="text/javascript">
			$j("#survey-<xsl:value-of select="$uniqueId"/>-page-<xsl:value-of select="position()"/>").hide();
		</script>
	</xsl:template>		
	
	<xsl:template match="question[@type = 'FREE_TEXT']">
		<div class="question free-text" id="survey-{$uniqueId}-q-{@name}">
			<div class="field">
				<div class="label">
					<label for="{@name}_{$uniqueId}">
						<span class="q">Q.<xsl:value-of select="count(preceding::question) + 1"/> - </span><xsl:value-of select="title"/>
						<xsl:if test="@mandatory = 'true'"><span class="mandatory-marker"><xsl:text> </xsl:text><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span></xsl:if>
					</label>
				</div>
                <xsl:call-template name="picture" >
	                <xsl:with-param name="picture" select="picture" />
	                <xsl:with-param name="alt" select="pictureAlternative" />
                    <xsl:with-param name="idObject" select="@id" />
                </xsl:call-template>  	    
				<div class="input">	
					<input type="text" name="{@name}" id="{@name}_{$uniqueId}" class="text"/>
				</div>
				<div class="field-end"/>
			</div>
		</div>
	</xsl:template>	
	
	<xsl:template match="question[@type = 'MULTILINE_FREE_TEXT']">
		<div class="question free-text multiple" id="survey-{$uniqueId}-q-{@name}">
            <div class="field">
				<div class="label">
					<label for="{@name}_{$uniqueId}">
						<span class="q">Q.<xsl:value-of select="count(preceding::question) + 1"/> - </span><xsl:value-of select="title"/>
						<xsl:if test="@mandatory = 'true'"><span class="mandatory-marker"><xsl:text> </xsl:text><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span></xsl:if>
					</label>
				</div>
    			<xsl:call-template name="picture" >
	                <xsl:with-param name="picture" select="picture" />
	                <xsl:with-param name="alt" select="pictureAlternative" />
                    <xsl:with-param name="idObject" select="@id" />
                </xsl:call-template>           
				<div class="input">	
					<textarea name="{@name}" id="{@name}_{$uniqueId}" rows="3" cols="10"></textarea>
				</div>
				<div class="field-end"/>
			</div>
		</div>
	</xsl:template>	
	
	<xsl:template match="question[@type = 'SINGLE_CHOICE']">
		<div class="question choice" id="survey-{$uniqueId}-q-{@name}">
            <fieldset>
				<legend>
					<span class="q">Q.<xsl:value-of select="count(preceding::question) + 1"/> - </span><xsl:value-of select="title"/>
					<xsl:if test="@mandatory = 'true'"><span class="mandatory-marker"><xsl:text> </xsl:text><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span></xsl:if>
				</legend>
				
				<xsl:call-template name="picture" >
	                <xsl:with-param name="picture" select="picture" />
	                <xsl:with-param name="alt" select="pictureAlternative" />
                    <xsl:with-param name="idObject" select="@id" />
                </xsl:call-template>
                   
				<div class="fields">         
					<xsl:variable name="name" select="@name"/>
					<xsl:for-each select="options/option">
						<div class="field">
							<div class="input">
								<input type="radio" id="{translate($name, ' ', '_')}_{@value}" name="{$name}" value="{@value}"/>
							</div>
							<div class="label">
								<label for="{translate($name, ' ', '_')}_{@value}"><xsl:value-of select="."/></label>
							</div>
							<div class="field-end"/>
						</div>
					</xsl:for-each>
					<xsl:if test="options/@other-option = 'true'">
						<xsl:variable name="val">__internal_other</xsl:variable>
						<div class="field">
							<div class="input">
								<input type="radio" id="{translate($name, ' ', '_')}_{$val}" name="{$name}" value="{$val}"/>
							</div>
							<div class="label">
								<label for="{translate($name, ' ', '_')}_{$val}"><i18n:text i18n:key="PLUGINS_SURVEY_OTHER_OPTION"/></label>
								<input type="text" name="__internal_other_{$name}" onkeyup="survey_otheropt_onkeyup(this, '{translate($name, ' ', '_')}_{$val}')"/>
							</div>
							<div class="field-end"/>
						</div>
					</xsl:if>
				</div>
			</fieldset>
		</div>
		
		<xsl:variable name="questionName" select="@name"/>
		<xsl:if test="../branches/rule[@name = $questionName]">
			<noscript>
				<p class="rules">
					<xsl:for-each select="../branches/rule[@name = $questionName]">
						<xsl:variable name="name" select="@name"/>
						<xsl:variable name="value" select="@value"/>
						<xsl:variable name="page" select="@page"/>
						<xsl:variable name="pageName" select="//page[@id = $page]/@name"/>
						
						<p>
							<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_ANSWER_START"/>
							<span class="answer"><xsl:value-of select="../../question[@name = $name]/options/option[@value = $value]"/></span>
							<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_ANSWER_END"/>
							
							<xsl:choose>
								<xsl:when test="@type = 'JUMP'">
									 <a href="#survey-{$uniqueId}-{//page[@id = $page]/@name}">
									 	<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_JUMP_TO_START"/><xsl:value-of select="count(//page[@id = $page]/preceding::question) + 1"/>
									 </a>
									 <i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_JUMP_TO_END"/>
								</xsl:when>
								<xsl:when test="@type = 'FINISH'">
									<a href="#survey-{$uniqueId}-end">
										<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_FINISH_START"/>
									</a>
									<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_FINISH_END"/>
								</xsl:when>
							</xsl:choose>
						</p>
					</xsl:for-each>
				</p>
			</noscript>
		</xsl:if>
	</xsl:template>	
	
	<xsl:template match="question[@type = 'MULTIPLE_CHOICE']">
		<div class="question choice multiple" id="survey-{$uniqueId}-q-{@name}">
            <fieldset>
				<legend>
					<span class="q">Q.<xsl:value-of select="count(preceding::question) + 1"/> - </span><xsl:value-of select="title"/>
					<xsl:if test="@mandatory = 'true'"><span class="mandatory-marker"><xsl:text> </xsl:text><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span></xsl:if>
				</legend>
			
			    <xsl:call-template name="picture" >
                    <xsl:with-param name="picture" select="picture" />
                    <xsl:with-param name="alt" select="pictureAlternative" />
                    <xsl:with-param name="idObject" select="@id" />
                </xsl:call-template>
                  
                <div class="fields"> 
					<xsl:variable name="name" select="@name"/>
					<xsl:for-each select="options/option">
						<div class="field">
							<div class="input">
								<input type="checkbox" name="{$name}" id="{translate($name, ' ', '_')}_{@value}" value="{@value}"/>
							</div>
							<div class="label">
								<label for="{translate($name, ' ', '_')}_{@value}"><xsl:value-of select="."/></label>
							</div>
							<div class="field-end"/>
						</div>
					</xsl:for-each>
					<xsl:if test="options/@other-option = 'true'">
						<xsl:variable name="val">__internal_other</xsl:variable>
						<div class="field">
							<div class="input">
								<input type="checkbox" id="{translate($name, ' ', '_')}_{$val}" name="{$name}" value="{$val}"/>
							</div>
							<div class="label">
								<label for="{translate($name, ' ', '_')}_{$val}"><i18n:text i18n:key="PLUGINS_SURVEY_OTHER_OPTION"/></label>
								<input type="text" name="__internal_other_{$name}" onkeyup="survey_otheropt_onkeyup(this, '{translate($name, ' ', '_')}_{$val}')"/>
							</div>
							<div class="field-end"/>
						</div>
					</xsl:if>
			     </div>
			</fieldset>
		</div>
		
		<xsl:variable name="questionName" select="@name"/>
		<xsl:if test="../branches/rule[@name = $questionName]">
			<noscript>
				<p class="rules">
					<xsl:for-each select="../branches/rule[@name = $questionName]">
						<xsl:variable name="name" select="@name"/>
						<xsl:variable name="value" select="@value"/>
						<xsl:variable name="page" select="@page"/>
						<xsl:variable name="pageName" select="//page[@id = $page]/@name"/>
					
						<p>	
							<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_ANSWER_START"/>
							<span class="answer"><xsl:value-of select="../../question[@name = $name]/options/option[@value = $value]"/></span>
							<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_ANSWER_END"/>
							
							<xsl:choose>
								<xsl:when test="@type = 'JUMP'">
									 <a href="#survey-{$uniqueId}-{//page[@id = $page]/@name}">
									 	<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_JUMP_TO_START"/><xsl:value-of select="count(//page[@id = $page]/preceding::question) -1"/>
									 </a>
									 <i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_JUMP_TO_END"/>
								</xsl:when>
								<xsl:when test="@type = 'FINISH'">
									<a href="#survey-{$uniqueId}-end">
										<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_FINISH_START"/>
									</a>
									<i18n:text i18n:key="PLUGINS_SURVEY_BRANCH_FINISH_END"/>
								</xsl:when>
							</xsl:choose>
						</p>
					</xsl:for-each>
				</p>
			</noscript>
		</xsl:if>
	</xsl:template>	
	
	<xsl:template match="question[@type = 'SINGLE_MATRIX' or @type = 'MULTIPLE_MATRIX']">
		<xsl:variable name="multiple" select="@type = 'MULTIPLE_MATRIX'"/>
	
		<div class="question matrix" id="survey-{$uniqueId}-q-{@name}">
            <fieldset>
				<legend>
					<span class="q">Q.<xsl:value-of select="count(preceding::question) + 1"/> - </span><xsl:value-of select="title"/>
					<xsl:if test="@mandatory = 'true'"><span class="mandatory-marker"><xsl:text> </xsl:text><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span></xsl:if>
				</legend>
				
				<xsl:call-template name="picture" >
                    <xsl:with-param name="picture" select="picture" />
                    <xsl:with-param name="alt" select="pictureAlternative" />
                    <xsl:with-param name="idObject" select="@id" />
                </xsl:call-template>
                
				<xsl:variable name="name" select="@name"/>
				<div class="field">

					<table>
						<tr>
							<td></td>
							<xsl:for-each select="columns/column">
								<td><xsl:value-of select="."/></td>
							</xsl:for-each>
						</tr>
					</table>
				
					<xsl:for-each select="options/option">
						<xsl:variable name="lineText" select="."/>
						<xsl:variable name="optName" select="concat($name, '_', @value)"/>

						<fieldset>
							<xsl:if test="position() mod 2 = 0"><xsl:attribute name="class">even</xsl:attribute></xsl:if>
							<legend><span class="legend"><xsl:value-of select="$lineText"/></span></legend>
							
							<table>
								<tr>
									<td class="legend"><xsl:value-of select="$lineText"/></td>
									
									<xsl:for-each select="../../columns/column">
										<xsl:variable name="colText" select="."/>
										
										<td>
											<xsl:choose>
												<xsl:when test="$multiple">
													<input type="checkbox" name="{$optName}" id="{translate($optName, ' ', '_')}_{$uniqueId}_{generate-id()}" value="{@value}" title="Choice {$lineText} is {$colText}"/>
												</xsl:when>
												<xsl:otherwise>
													<input type="radio" name="{$optName}" id="{translate($optName, ' ', '_')}_{$uniqueId}_{generate-id()}" value="{@value}"/>
												</xsl:otherwise>
											</xsl:choose>
											<label for="{translate($optName, ' ', '_')}_{$uniqueId}_{generate-id()}"><xsl:value-of select="."/></label>
										</td>
									</xsl:for-each>
								</tr>
							</table>
						</fieldset>
					</xsl:for-each>
				</div>
			</fieldset>
		</div>
	</xsl:template>	
	
	<xsl:template match="question[(@type = 'FREE_TEXT' or @type = 'MULTILINE_FREE_TEXT') and @mandatory = 'true']" mode="check-mandatory">
		var value = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').val();
		if (value == '')
		{
			$j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').parents('div.input').addClass('invalid');
			errors.push({label: '<xsl:value-of select="ametys:escapeJS(title)"/>', message: "<i18n:text i18n:key="PLUGINS_SURVEY_FORM_ERROR_MANDATORY"/>"});
		}
	</xsl:template>
	
	<xsl:template match="question[(@type = 'SINGLE_CHOICE' or @type = 'MULTIPLE_CHOICE') and @mandatory = 'true']" mode="check-mandatory">
		if (survey_input_radio_empty('survey-<xsl:value-of select="$uniqueId"/>-form', '<xsl:value-of select="@name"/>'))
		{
			var inputs = $j('input[name="<xsl:value-of select="@name"/>"]');
			$j(inputs.get(0)).parents('fieldset').addClass('invalid');
			errors.push({label: '<xsl:value-of select="ametys:escapeJS(title)"/>', message: "<i18n:text i18n:key="PLUGINS_SURVEY_FORM_ERROR_MANDATORY"/>"});
		}
	</xsl:template>
	
	<xsl:template match="question[(@type = 'SINGLE_MATRIX' or @type = 'MULTIPLE_MATRIX') and @mandatory = 'true']" mode="check-mandatory">
		<xsl:variable name="name" select="@name"/>

		var atLeastEmptyLine = false;
		<xsl:for-each select="options/option">
			<xsl:variable name="lineText" select="."/>
			<xsl:variable name="optName" select="concat($name, '_', @value)"/>
		
			if (survey_input_radio_empty ('survey-<xsl:value-of select="$uniqueId"/>-form', '<xsl:value-of select="$optName"/>'))
			{
				atLeastEmptyLine = true;
			}
		</xsl:for-each>		
		
		if (atLeastEmptyLine)
		{
			var inputs = $j('input[name="<xsl:value-of select="concat($name, '_', options/option/@value)"/>"]');
			$j(inputs.get(0)).parents('fieldset').addClass('invalid');
			
			errors.push({label: '<xsl:value-of select="ametys:escapeJS(title)"/>', message: "<i18n:text i18n:key="PLUGINS_SURVEY_FORM_ERROR_MANDATORY_MATRIX"/>"});
		}				
	</xsl:template>
	
	<xsl:template match="question[@type = 'FREE_TEXT' and regexp and regexp != '']" mode="check-regexp">
		var value = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').val();
		if (value != '' &amp;&amp; !/<xsl:value-of select="pattern"/>/.test(value))
		{
			$j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').parents('div.input').addClass('invalid');
			
			var msg = survey_regexp_error_msg ('<xsl:value-of select="regexp"/>');
			errors.push({label: '<xsl:value-of select="ametys:escapeJS(title)"/>', message: msg});
		}
	</xsl:template>
	
	<xsl:template name="picture">
	   <xsl:param name="class">picture</xsl:param>
	   <xsl:param name="picture"/>
	   <xsl:param name="alt"/>
       <xsl:param name="idObject" />
	   <xsl:param name="maxHeight">150</xsl:param>
	   <xsl:param name="maxWidth">150</xsl:param>
	   
       <xsl:if test="$picture/@pictureType != ''">
            <div class="{$class}">
                <xsl:variable name="id">
                    <xsl:choose>
                        <xsl:when test="$picture/@pictureType = 'resource'">
                            <xsl:value-of select="$picture/@pictureId"/>
                        </xsl:when>
                        <xsl:when test="$picture/@pictureType = 'external'">
                            <xsl:value-of select="concat($picture/@picturePath, '?objectId=', $idObject)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <img src="{resolver:resolveBoundedImage($picture/@imageType, $id, $maxHeight, $maxWidth)}">
                    <xsl:attribute name="alt"><xsl:value-of select="$alt"/></xsl:attribute>
                </img>
            </div>
        </xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
