/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;

/**
 * Get the url of survey form
 */
public class GetSurveyActionUrl extends AbstractSurveyAction
{
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Map<String, String> result = new HashMap<>();
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        String surveyId = request.getParameter("id");
        
        Survey survey = _resolver.resolveById(surveyId);
        
        String xpathQuery = "//element(" + survey.getSiteName() + ", ametys:site)/ametys-internal:sitemaps/" + survey.getLanguage()
                + "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.survey.service.Display' and ametys:service_parameters/@ametys:surveyId = '" + surveyId + "']";

        AmetysObjectIterable<ZoneItem> zoneItems = _resolver.query(xpathQuery);
        Iterator<ZoneItem> it = zoneItems.iterator();
        if (it.hasNext())
        {
            SitemapElement sitemapElement = it.next().getZone().getSitemapElement();
            
            Site site = _siteManager.getSite(sitemapElement.getSiteName());
            result.put("actionUrl", site.getUrl() + "/" + sitemapElement.getSitemapName() + "/_plugins/survey/" + sitemapElement.getTemplate() + "/finish.html");
        }
        else
        {
            Site site = _siteManager.getSite(survey.getSiteName());
            result.put("actionUrl", site.getUrl() + "/" + survey.getLanguage() + "/_plugins/survey/page/finish.html");
        }
        
        return result;
    }
}
