/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.clientsideelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;

/**
 * This element creates a toggle button representing the validated state of a survey
 */
public class ValidateSurveyClientSideElement extends StaticClientSideElement
{
    /** The ametys object resolver. */
    protected AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _resolver = (AmetysObjectResolver) serviceManager.lookup(AmetysObjectResolver.ROLE);
    }
    
    /**
     * Get the validation status for a given survey
     * @param surveyId The survey id
     * @return The validation status
     */
    @Callable(rights = "Plugins_Survey_Right_Validate", context = "/cms")
    public Map<String, Object> getStatus(String surveyId)
    {
        Map<String, Object> results = new HashMap<>();
        
        Survey survey = _resolver.resolveById(surveyId);
        
        boolean isValidated = survey.isValidated();
        
        List<String> i18nParameters = new ArrayList<>();
        i18nParameters.add(StringUtils.isNotEmpty(survey.getTitle()) ? survey.getTitle() : survey.getLabel());
        
        I18nizableText msg = null;
        if (isValidated)
        {
            I18nizableText ed = (I18nizableText) this._script.getParameters().get("validated-description");
            msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
        }
        else
        {
            I18nizableText ed = (I18nizableText) this._script.getParameters().get("to-validate-description");
            msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
        }
        
        
        results.put("validate-description", msg);
        results.put("validated", Boolean.toString(isValidated));
        
        return results;
    }

}
