/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.observation;

import java.util.Map;

import org.ametys.core.ObservationConstants;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.survey.repository.Survey;

/**
 * {@link Observer} for observing survey alc update in order to invalidate cache on front-office.
 */
public class InvalidateCacheOnSurveyAclUpdated extends AbstractSurveyCacheObserver
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_ACL_UPDATED);
    }

    @Override
    protected Survey getSurveyFromEvent(Event event)
    {
        Map<String, Object> args = event.getArguments();
        if (args.containsKey(ObservationConstants.ARGS_ACL_CONTEXT)
                && args.get(ObservationConstants.ARGS_ACL_CONTEXT) != null
                && args.get(ObservationConstants.ARGS_ACL_CONTEXT) instanceof Survey)
        {
            return (Survey) args.get(ObservationConstants.ARGS_ACL_CONTEXT);
        }

        return null;
    }
}
