/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.translationflagging;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.group.ModelLessComposite;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.LocaleUtils;

public class TranslationAlertFunction
extends AbstractContentWorkflowComponent
implements EnhancedFunction,
Initializable,
PluginAware {
    public static final String I18N_KEY_SUBJECT = "PLUGINS_TRANSLATIONFLAGGING_ALERT_EMAIL_SUBJECT";
    public static final String I18N_KEY_BODY_TITLE = "PLUGINS_TRANSLATIONFLAGGING_ALERT_EMAIL_BODY_TITLE";
    public static final String I18N_KEY_BODY = "PLUGINS_TRANSLATIONFLAGGING_ALERT_EMAIL_BODY";
    protected UserManager _userManager;
    protected RightManager _rightManager;
    protected I18nUtils _i18nUtils;
    protected AmetysObjectResolver _resolver;
    protected String _pluginName;
    protected String _baseUrl;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void initialize() throws Exception {
        this._baseUrl = StringUtils.removeEndIgnoreCase((String)((String)Config.getInstance().getValue("cms.url")), (String)"index.html");
        if (!this._baseUrl.endsWith("/")) {
            this._baseUrl = this._baseUrl + "/";
        }
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        WebContent webContent;
        Site site;
        boolean enabled;
        this._logger.info("Performing translation alerts workflow function.");
        WorkflowAwareContent content = this.getContent(transientVars);
        if (content instanceof WebContent && !this._contentHelper.isMultilingual((Content)content) && (enabled = ((Boolean)(site = (webContent = (WebContent)content).getSite()).getValue("translationflagging-enable-alerts", false, (Object)false)).booleanValue())) {
            this.sendAlerts((WebContent)content);
        }
    }

    protected void sendAlerts(WebContent content) {
        for (Page page : content.getReferencingPages()) {
            Site site = content.getSite();
            String masterLanguage = (String)site.getValue("master-language");
            if (!StringUtils.isEmpty((String)masterLanguage) && !page.getSitemapName().equals(masterLanguage)) continue;
            Collection<Page> translatedPages = this.getTranslations(page).values();
            for (Page translatedPage : translatedPages) {
                HashSet<UserIdentity> users = this.getUsersToNotify(translatedPage);
                this.sendAlert(page, content, translatedPage, users);
            }
        }
    }

    protected void sendAlert(Page page, WebContent content, Page translatedPage, Set<UserIdentity> users) {
        ArrayList<String> params = new ArrayList<String>();
        Site site = page.getSite();
        String mailFrom = (String)site.getValue("site-mail-from");
        String pageLang = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.web", "I18NKEY_LANGUAGE_" + page.getSitemapName().toUpperCase()));
        String translatedLang = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.web", "I18NKEY_LANGUAGE_" + translatedPage.getSitemapName().toUpperCase()));
        params.add(page.getSite().getTitle());
        params.add(content.getTitle(LocaleUtils.toLocale((String)page.getSitemapName())));
        params.add(page.getTitle());
        params.add(pageLang.toLowerCase());
        params.add(translatedPage.getTitle());
        params.add(translatedLang.toLowerCase());
        params.add(this.getPageUrl(page));
        params.add(this.getPageUrl(translatedPage));
        String catalogue = "plugin." + this._pluginName;
        I18nizableText i18nSubject = new I18nizableText(catalogue, I18N_KEY_SUBJECT, params);
        I18nizableText i18nBody = new I18nizableText(catalogue, I18N_KEY_BODY, params);
        try {
            String subject = this._i18nUtils.translate((I18nizable)i18nSubject);
            String htmlBody = StandardMailBodyHelper.newHTMLBody().withTitle(new I18nizableText(catalogue, I18N_KEY_BODY_TITLE, params)).withMessage(i18nBody).withLink(this.getPageUrl(translatedPage), new I18nizableText(catalogue, "PLUGINS_TRANSLATIONFLAGGING_ALERT_EMAIL_BODY_TRANSLATED_PAGE_LINK")).build();
            this.sendMails(subject, htmlBody, users, mailFrom);
        }
        catch (IOException e) {
            this._logger.error("Unable to build HTML body for email alert on translation", (Throwable)e);
        }
    }

    protected void sendMails(String subject, String htmlBody, Set<UserIdentity> users, String from) {
        block2: {
            List recipients = users.stream().map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).map(User::getEmail).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            try {
                SendMailHelper.newMail().withSubject(subject).withHTMLBody(htmlBody).withSender(from).withRecipients(recipients).sendMail();
            }
            catch (MessagingException | IOException e) {
                if (!this._logger.isWarnEnabled()) break block2;
                this._logger.warn("Could not send a translation alert e-mail to " + String.valueOf(recipients), e);
            }
        }
    }

    protected HashSet<UserIdentity> getUsersToNotify(Page translatedPage) {
        HashSet<UserIdentity> users = new HashSet<UserIdentity>();
        Set editors = this._rightManager.getAllowedUsers("Workflow_Rights_Edition_Online", (Object)translatedPage).resolveAllowedUsers(((Boolean)Config.getInstance().getValue("runtime.mail.massive.sending")).booleanValue());
        Set usersToNotify = this._rightManager.getAllowedUsers("TranslationFlagging_Rights_Notification", (Object)translatedPage).resolveAllowedUsers(((Boolean)Config.getInstance().getValue("runtime.mail.massive.sending")).booleanValue());
        users.addAll(editors);
        users.retainAll(usersToNotify);
        return users;
    }

    protected Map<String, Page> getTranslations(Page page) {
        HashMap<String, Page> translations = new HashMap<String, Page>();
        ModelLessComposite translationsComposite = page.getComposite("translations");
        if (translationsComposite != null) {
            for (String lang : translationsComposite.getDataNames()) {
                String translatedPageId = (String)translationsComposite.getValue(lang);
                Page translatedPage = (Page)this._resolver.resolveById(translatedPageId);
                translations.put(lang, translatedPage);
            }
        }
        return translations;
    }

    protected String getPageUrl(Page page) {
        StringBuilder url = new StringBuilder(this._baseUrl);
        url.append(page.getSite().getName()).append("/index.html?uitool=uitool-page,id:%27").append(page.getId()).append("%27");
        return url.toString();
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.translationflagging", "PLUGINS_TRANSLATIONFLAGGING_ALERT_FUNCTION_LABEL");
    }
}

