/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.translationflagging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.translationflagging.TranslationPageDAO;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;

public class TranslationFlaggingClientSideElement
extends StaticClientSideElement {
    public static final String TRANSLATIONS_META = "translations";
    private AmetysObjectResolver _resolver;
    private SiteManager _siteManager;
    private TranslationPageDAO _translationPageDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._translationPageDAO = (TranslationPageDAO)((Object)smanager.lookup(TranslationPageDAO.ROLE));
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        Site site;
        String siteName = (String)contextParameters.get("siteName");
        if (siteName != null && (site = this._siteManager.getSite(siteName)).getSitemaps().getSize() > 1L) {
            return super.getScripts(ignoreRights, contextParameters);
        }
        return new ArrayList<ClientSideElement.Script>();
    }

    @Callable(rights={"TranslationFlagging_Rights_Set"}, rightContext="right.assignment.context.pageaccess", paramIndex=0)
    public Map<String, Object> getTranslations(String pageId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        result.put("page", this._page2json(page));
        Map<String, Page> translatedPages = this._translationPageDAO.getTranslations(page);
        ArrayList<Map<String, String>> translations = new ArrayList<Map<String, String>>();
        for (Page translatedPage : translatedPages.values()) {
            translations.add(this._page2json(translatedPage));
        }
        result.put(TRANSLATIONS_META, translations);
        return result;
    }

    private Map<String, String> _page2json(Page page) {
        HashMap<String, String> pageData = new HashMap<String, String>();
        pageData.put("id", page.getId());
        pageData.put("site", page.getSiteName());
        pageData.put("lang", page.getSitemapName());
        pageData.put("path", page.getPathInSitemap());
        pageData.put("title", page.getTitle());
        return pageData;
    }

    @Callable(rights={"TranslationFlagging_Rights_Set"}, rightContext="right.assignment.context.pageaccess", paramIndex=0)
    public List<String> setTranslations(String pageId, Map<String, String> translations) {
        Map<String, Page> pages = this._getTranslatedPages(translations, pageId);
        return this._translationPageDAO.setTranslations(pageId, pages);
    }

    protected Map<String, Page> _getTranslatedPages(Map<String, String> translations, String pageId) {
        HashMap<String, Page> pages = new HashMap<String, Page>();
        Page currentPage = (Page)this._resolver.resolveById(pageId);
        String siteName = currentPage.getSiteName();
        pages.put(currentPage.getSitemapName(), currentPage);
        Site site = this._siteManager.getSite(siteName);
        AmetysObjectIterable sitemaps = site.getSitemaps();
        for (Sitemap sitemap : sitemaps) {
            String name = sitemap.getSitemapName();
            if (name.equals(currentPage.getSitemapName())) continue;
            if (translations.containsKey(name) && StringUtils.isNotBlank((String)translations.get(name))) {
                Page page = (Page)this._resolver.resolveById(translations.get(name));
                if (!name.equals(page.getSitemapName())) continue;
                pages.put(name, page);
                continue;
            }
            pages.put(name, null);
        }
        return pages;
    }
}

