/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.translationflagging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.group.ModelLessComposite;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelLessComposite;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class TranslationPageDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = TranslationPageDAO.class.getName();
    private AmetysObjectResolver _resolver;
    private CurrentUserProvider _currentUserProvider;
    private ObservationManager _observationManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
    }

    public List<String> setTranslations(String pageId, Map<String, Page> pages) {
        Page currentPage = (Page)this._resolver.resolveById(pageId);
        HashSet<Page> pagesToClean = new HashSet<Page>(this.getTranslations(currentPage).values());
        HashSet<Page> modifiedPages = new HashSet<Page>(pagesToClean);
        modifiedPages.addAll(pages.values());
        pagesToClean.removeAll(pages.values());
        for (Page page : pagesToClean) {
            if (!(page instanceof ModifiablePage)) continue;
            this._cleanPage((ModifiablePage)page);
        }
        for (Page page : pages.values()) {
            if (!(page instanceof ModifiablePage)) continue;
            this._setTranslations((ModifiablePage)page, pages);
        }
        ArrayList<String> modifiedPageIds = new ArrayList<String>();
        for (Page modifiedPage : modifiedPages) {
            if (modifiedPage == null) continue;
            modifiedPageIds.add(modifiedPage.getId());
            HashMap<String, Page> eventParams = new HashMap<String, Page>();
            eventParams.put("page", modifiedPage);
            this._observationManager.notify(new Event("page.updated", this._currentUserProvider.getUser(), eventParams));
        }
        return modifiedPageIds;
    }

    public Map<String, Page> getTranslations(Page page) {
        HashMap<String, Page> translations = new HashMap<String, Page>();
        ModelLessComposite translationsComposite = page.getComposite("translations");
        if (translationsComposite != null) {
            for (String lang : translationsComposite.getDataNames()) {
                String translatedPageId = (String)translationsComposite.getValue(lang);
                try {
                    Page translatedPage = (Page)this._resolver.resolveById(translatedPageId);
                    translations.put(lang, translatedPage);
                }
                catch (UnknownAmetysObjectException unknownAmetysObjectException) {}
            }
        }
        return translations;
    }

    protected void _setTranslations(ModifiablePage page, Map<String, Page> pages) {
        ModifiableModelLessComposite translationsComposite = page.getComposite("translations", true);
        for (Map.Entry<String, Page> entry : pages.entrySet()) {
            if (entry.getKey().equals(page.getSitemapName())) continue;
            if (entry.getValue() == null) {
                translationsComposite.removeValue(entry.getKey());
                continue;
            }
            translationsComposite.setValue(entry.getKey(), (Object)entry.getValue().getId());
        }
        page.saveChanges();
    }

    protected void _cleanPage(ModifiablePage page) {
        page.removeValue("translations");
        if (page.needsSave()) {
            page.saveChanges();
        }
    }
}

