/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Actions for the translation selection button
 */
Ext.define("Ametys.plugins.translationflagging.TranslationActions", {
    singleton: true,
    
    /**
     * Set translation flag on the current page
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller that called the action
     */
    flag: function (controller)
    {
    	var target = controller.getMatchingTargets()[0];
        if (target != null)
        {
        	controller.serverCall('getTranslations', [target.getParameters().id], Ext.bind(this._getTranslationsCb, this, [controller], true), { 
                errorMessage: {
                    msg: "{{i18n PLUGINS_TRANSLATIONFLAGGING_GET_TRANSLATIONS_ERROR}}", 
                    category: Ext.getClassName(this)
                },
                waitMessage: true
            }, true);
        	
        }
    },
    
    /**
     * Callback function invoked after retrieving page's translation
     * @param {Object} response the server response
     * @param {Object} response.page the page's information
     * @param {Object[]} response.translations the page's translations
     * @param {Object} args The callback arguments
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller that called the #flag method
     */
    _getTranslationsCb: function (response, args, controller)
    {
    	Ametys.plugins.translationflagging.TranslationHelper.open ({
    		id: response.page.id,
    		lang: response.page.lang,
    		title: response.page.title,
    		translations: response.translations,
    		callback: Ext.bind (this._setTranslations, this, [controller], true)
    	})
    },
    
    /**
     * @private
     * Callback function invoked after validating {@link Ametys.plugins.translationflagging.TranslationHelper} dialog box.
     * Set translation flag.
     * @param {String} id The page's id
     * @param {Object} translations the page's translations
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller that called the #flag method
     */
    _setTranslations: function (id, translations, controller)
    {
    	controller.serverCall('setTranslations',  [id, translations], Ext.bind(this._setTranslationsCb, this), { 
            errorMessage: {
                msg: "{{i18n PLUGINS_TRANSLATIONFLAGGING_SET_TRANSLATIONS_ERROR}}", 
                category: 'Ametys.plugins.translationflagging.SetTranslation',
                ignoreCallback: false
            },
            waitMessage: true
        }, true);
    },
    
    /**
     * @private
     * Callback function invoked after setting flag translation
     * @param {String[]} pageIds The ids of updated pages.
     */
    _setTranslationsCb: function (pageIds)
    {
    	Ext.create('Ametys.message.Message', {
            type: Ametys.message.Message.MODIFIED,
            
            targets: {
                id: Ametys.message.MessageTarget.PAGE,
                parameters: { ids: pageIds }
            }
        });
    }
});
