/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.accesscontroller;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeOrMixinExpression;
import org.ametys.cms.rights.ContentAccessController;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractRightBasedAccessController;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class UGCCreatorContentAccessController
extends AbstractRightBasedAccessController
implements Serviceable {
    private static final List<String> __CREATOR_RIGHTS = List.of("Front_Edition_Access_Right", "Workflow_Rights_Edition_Online", "CMS_Rights_DeleteContent", "Workflow_Rights_Validate");
    protected ContentTypesHelper _cTypeHelper;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._cTypeHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Object object) {
        return object instanceof Content && this._cTypeHelper.isInstanceOf((Content)object, "org.ametys.plugins.ugc.Mixin");
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        if (object instanceof Content && ((Content)object).getCreator().equals((Object)user)) {
            return __CREATOR_RIGHTS.contains(rightId) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        HashMap<String, AccessController.AccessResult> permissionByRight = new HashMap<String, AccessController.AccessResult>();
        if (((Content)object).getCreator().equals((Object)user)) {
            for (String rightId : __CREATOR_RIGHTS) {
                permissionByRight.put(rightId, AccessController.AccessResult.USER_ALLOWED);
            }
        }
        return permissionByRight;
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> permissionByUser = new HashMap<UserIdentity, AccessController.AccessResult>();
        if (__CREATOR_RIGHTS.contains(rightId)) {
            permissionByUser.put(((Content)object).getCreator(), AccessController.AccessResult.USER_ALLOWED);
        }
        return permissionByUser;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    protected AccessExplanation _getAccessExplanation(AccessController.AccessResult result, Object object, UserIdentity user, Set<GroupIdentity> groups, String rightId) {
        switch (result) {
            case USER_ALLOWED: 
            case UNKNOWN: {
                return new AccessExplanation(this.getId(), result, new I18nizableText("plugin.ugc", "PLUGINS_UGC_CREATOR_ACCESS_CONTROLLER_" + result.name() + "_EXPLANATION", Map.of("title", new I18nizableText(((Content)object).getTitle()))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)result);
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Content) {
            Content content = (Content)object;
            return new I18nizableText(content.getTitle());
        }
        throw new RightsException("Unsupported context: " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return ContentAccessController.CONTENT_CONTEXT_CATEGORY;
    }

    protected Iterable<? extends Object> getHandledObjects(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        if (StringUtils.isNotBlank((CharSequence)siteName)) {
            ContentTypeOrMixinExpression typeExpr = new ContentTypeOrMixinExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.ugc.Mixin"});
            UserExpression userExpression = new UserExpression("creator", Expression.Operator.EQ, identity);
            StringExpression siteExpression = new StringExpression("site", Expression.Operator.EQ, siteName);
            String query = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression(new Expression[]{typeExpr, userExpression, siteExpression}));
            return this._resolver.query(query);
        }
        return List.of();
    }

    protected Collection<String> getHandledRights() {
        return __CREATOR_RIGHTS;
    }
}

