/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.cachepolicy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.core.observation.Event;
import org.ametys.plugins.ugc.page.UGCPageHandler;
import org.ametys.web.cache.pageelement.PageElementCachePolicy;
import org.ametys.web.inputdata.SitemapInputData;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UGCVirtualPagesCachePolicy
extends AbstractLogEnabled
implements Serviceable,
PageElementCachePolicy {
    private static final Set<String> _UGC_PE_TYPES = new HashSet<String>();
    protected UGCPageHandler _ugcPageHandler;

    public void service(ServiceManager manager) throws ServiceException {
        this._ugcPageHandler = (UGCPageHandler)((Object)manager.lookup(UGCPageHandler.ROLE));
    }

    public Set<String> getPageElementTypes() {
        return _UGC_PE_TYPES;
    }

    public final PageElementCachePolicy.PolicyResult shouldClearCache(String workspace, Site site, String pageElementType, Event event) {
        Object object;
        String id = event.getId();
        if (this._getRemovingCacheEventIds(workspace).contains(id) && (object = event.getArguments().get("content")) instanceof ModifiableDefaultContent) {
            ModifiableDefaultContent content = (ModifiableDefaultContent)object;
            try {
                for (String contentTypeId : content.getTypes()) {
                    for (Sitemap sitemap : site.getSitemaps()) {
                        if (this._ugcPageHandler.getUGCRootPage(site.getName(), sitemap.getSitemapName(), contentTypeId) == null) continue;
                        return PageElementCachePolicy.PolicyResult.REMOVE;
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().error("An error occurred with an event on content " + content.getId(), (Throwable)e);
                return PageElementCachePolicy.PolicyResult.KEEP;
            }
        }
        return PageElementCachePolicy.PolicyResult.KEEP;
    }

    public final PageElementCachePolicy.PolicyResult shouldClearCache(String workspace, Site site, String pageElementType, String elementId, Event event) {
        throw new UnsupportedOperationException("Should never be called.");
    }

    protected List<String> _getRemovingCacheEventIds(String workspace) {
        if ("default".equals(workspace)) {
            return Arrays.asList("content.added", "content.modified", "content.deleted");
        }
        if ("live".equals(workspace)) {
            return Arrays.asList("content.added", "content.validated", "content.deleted", "content.untag.live");
        }
        return Collections.emptyList();
    }

    static {
        _UGC_PE_TYPES.add(SitemapInputData.class.getName());
        _UGC_PE_TYPES.add("SERVICE:org.ametys.web.service.SitemapService");
    }
}

