/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.observation;

import java.util.Map;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.plugins.ugc.page.UGCPage;
import org.ametys.plugins.ugc.page.UGCPageHandler;
import org.ametys.plugins.ugc.page.VirtualUGCPageFactory;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.pageelement.PageElementCache;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;

public abstract class AbstractContentObserver
extends AbstractLogEnabled
implements Observer,
Serviceable,
Contextualizable {
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _cocoonContext;
    protected AmetysObjectResolver _resolver;
    protected ContentTypesHelper _contentTypeHelper;
    protected PageElementCache _zoneItemCache;
    protected UGCPageHandler _ugcPageHandler;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypeHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._zoneItemCache = (PageElementCache)manager.lookup(PageElementCache.ROLE + "/zoneItem");
        this._ugcPageHandler = (UGCPageHandler)((Object)manager.lookup(UGCPageHandler.ROLE));
    }

    public void observe(Event event, Map<String, Object> transientVars) {
        try {
            Content content = this._getTarget(event);
            AmetysObjectIterable<Page> rootPages = this._getUGCRootPages();
            if (!rootPages.iterator().hasNext()) {
                this.getLogger().debug("There's no UGC root page, nothing to invalidate");
                return;
            }
            for (Page rootPage : rootPages) {
                if (!this._isUGCContent(content, rootPage)) continue;
                this._internalObserve(event, rootPage, content);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Unable to observe event: " + String.valueOf(event), (Throwable)e);
        }
    }

    protected abstract void _internalObserve(Event var1, Page var2, Content var3);

    protected AmetysObjectIterable<Page> _getUGCRootPages() {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(VirtualUGCPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery(null, null, null, (Expression)expression, null);
        return this._resolver.query(query);
    }

    protected Content _getTarget(Event event) throws Exception {
        return (Content)event.getArguments().get("content");
    }

    protected boolean _isUGCContent(Content content, Page rootPage) {
        String contentTypeId = this._ugcPageHandler.getContentTypeId(rootPage);
        return content != null && this._contentTypeHelper.isInstanceOf(content, contentTypeId);
    }

    protected void _removeZoneItemCache(Page rootPage, Content content, String workspace) {
        Optional<UGCPage> ugcPage;
        if (this._isUGCContent(content, rootPage) && (ugcPage = this._ugcPageHandler.getUgcPage(rootPage, content)).isPresent()) {
            AmetysObjectIterable zones = ugcPage.get().getZones();
            for (Zone zone : zones) {
                for (ZoneItem zoneItem : zone.getZoneItems()) {
                    this._zoneItemCache.removeItem(workspace, rootPage.getSiteName(), "CONTENT", zoneItem.getId());
                }
            }
        }
    }
}

