/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.ugc.page;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.ugc.page.UGCPageHandler;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.apache.commons.lang3.LocaleUtils;

public interface TransitionalPageInformation {
    public String getKey();

    public String getAttributeValue();

    public String getTitle();

    default public Map<String, String> getInfo() {
        return ImmutableMap.of((Object)"metadata_value", (Object)this.getAttributeValue(), (Object)"title", (Object)this.getTitle());
    }

    public static class TypeEnum
    implements TransitionalPageInformation {
        private String _key;
        private I18nizableText _text;
        private UGCPageHandler _ugcPageHandler;

        TypeEnum(UGCPageHandler ugcPageHandler, String key, I18nizableText text) {
            this._ugcPageHandler = ugcPageHandler;
            this._key = key;
            this._text = text;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public String getAttributeValue() {
            return this._key;
        }

        @Override
        public String getTitle() {
            return this._ugcPageHandler._i18nUtils.translate((I18nizable)this._text);
        }
    }

    public static class TypeContent
    implements TransitionalPageInformation {
        private Content _content;
        private Page _rootPage;

        TypeContent(Content content, Page rootPage) {
            this._content = content;
            this._rootPage = rootPage;
        }

        @Override
        public String getKey() {
            return this._content.getName();
        }

        @Override
        public String getAttributeValue() {
            return this._content.getId();
        }

        @Override
        public String getTitle() {
            return this._content.getTitle(LocaleUtils.toLocale((String)this._rootPage.getSitemapName()));
        }
    }
}

