/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.ugc.observation;

/**
 * Observation constants for UGC plugin
 */
public interface ObservationConstants
{
    /** Event id when a ugc root page is being deleted. */
    public static final String EVENT_UGC_ROOT_DELETING = "ugc.root.deleting";
    /** Event id when a ugc root page is deleted. */
    public static final String EVENT_UGC_ROOT_DELETED = "ugc.root.deleted";
    /** Event id when a ugc root page is being updated. */
    public static final String EVENT_UGC_ROOT_UPDATING = "ugc.root.updating";
    /** Event id when a ugc root page is updated. */
    public static final String EVENT_UGC_ROOT_UPDATED = "ugc.root.updated";
    /** Event id when a ugc page is changed. */
    public static final String EVENT_UGC_ROOT_CHANGED = "ugc.root.changed";
    /** Event id when a ugc content has been accepted. */
    public static final String EVENT_UGC_CONTENT_ACCEPTED = "ugc.content.accepted";
    /** Event id when a ugc content has been refused. */
    public static final String EVENT_UGC_CONTENT_REFUSED = "ugc.content.refused";
    /** Argument for notification on refuse event. */
    public static final String ARGS_UGC_REFUSE_NOTIFY = "ugc.refuse.notify";
    /** Argument for comment on refuse event. */
    public static final String ARGS_UGC_REFUSE_COMMENT = "ugc.refuse.comment";
}
