/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.ugc.page;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPageFactory;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;
import org.ametys.web.skin.SkinsManager;

/**
 * Common class for factories of UGC virtual pages
 */
public abstract class AbstractUGCPageFactory extends AbstractConfigurableVirtualPageFactory
{
    /** The UGC page handler */
    protected UGCPageHandler _ugcPageHandler;
    /** The skin manager */
    protected SkinsManager _skinManager;
    
    @Override
    public void deferredService(ServiceManager manager) throws ServiceException
    {
        super.deferredService(manager);

        _ugcPageHandler = (UGCPageHandler) manager.lookup(UGCPageHandler.ROLE);
        _skinManager = (SkinsManager) manager.lookup(SkinsManager.ROLE);
    }
    
    /**
     * Get the configuration for the virtual page
     * @param rootPage The root page of the virtual hierarchy
     * @return The CourseVirtualPageConfiguraton
     */
    public VirtualPageConfiguration getConfiguration(Page rootPage) 
    {
        String contentType = _ugcPageHandler.getContentTypeId(rootPage);

        if (_virtualPageConfigurationEP.hasExtension(_configurationId + "." + contentType))
        {
            return _virtualPageConfigurationEP.getExtension(_configurationId + "." + contentType);
        }
        else
        {
            return super.getConfiguration();
        }
    }
    
    /**
     * Get the ugc page handler
     * @return <code>UGCPageHandler</code>
     */
    protected UGCPageHandler getUgcPageHandler()
    {
        return _ugcPageHandler;
    }
    
    UGCPageFactory getUGCPageFactory()
    {
        return (UGCPageFactory) _ametysObjectFactoryEP.getExtension(UGCPageFactory.class.getName());
    }
    
    UGCTransitionalPageFactory getTransitionalPageFactory()
    {
        return (UGCTransitionalPageFactory) _ametysObjectFactoryEP.getExtension(UGCTransitionalPageFactory.class.getName());
    }
}
