/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.repository.ACLAmetysObject;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.userdirectory.page.UserPageFactory;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPageFactory;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class UserPage
extends AbstractConfigurableVirtualPage<UserPageFactory>
implements ACLAmetysObject {
    private int _initialDepth;
    private String _title;
    private String _path;
    private Content _syncContent;

    public UserPage(Page root, VirtualPageConfiguration configuration, String scheme, UserPageFactory factory, Content syncContent, String path) {
        super(root, configuration, scheme, (AbstractConfigurableVirtualPageFactory)factory);
        this._path = path;
        this._syncContent = syncContent;
        this._title = this._syncContent.getTitle(LocaleUtils.toLocale((String)root.getSitemapName()));
        this._initialDepth = ((UserPageFactory)this._factory).getUserDirectoryPageHandler().getDepth(this._root);
    }

    public static String getId(String path, String rootId, String contentId) {
        return "uduser://" + (StringUtils.isEmpty((CharSequence)path) ? "_root" : path) + "?rootId=" + rootId + "&contentId=" + contentId;
    }

    public Content getContent() {
        return this._syncContent;
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + this._initialDepth + 1;
    }

    public Set<String> getReferers() throws AmetysRepositoryException {
        return null;
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        ArrayList children = new ArrayList();
        return new CollectionIterable(children);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        if (this._path.equals("_root")) {
            return this._root.getPathInSitemap() + "/" + this.getName();
        }
        String path = StringUtils.lowerCase((String)this._path);
        return this._root.getPathInSitemap() + "/" + path + "/" + this.getName();
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        return null;
    }

    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        return false;
    }

    public String getId() throws AmetysRepositoryException {
        return UserPage.getId(this._path, this._root.getId(), this._syncContent.getId());
    }

    public String getName() throws AmetysRepositoryException {
        return this._syncContent.getName();
    }

    public Page getParent() throws AmetysRepositoryException {
        if (this._initialDepth > 0) {
            String pathName = StringUtils.substringAfterLast((String)this._path, (String)"/");
            String name = ((UserPageFactory)this._factory).getUserDirectoryPageHandler().getName(pathName);
            return ((UserPageFactory)this._factory).getTransitionalPageFactory().createTransitionalPage(this._root, name, this._path);
        }
        return this._root;
    }

    public String getParentPath() throws AmetysRepositoryException {
        if (this._initialDepth > 0) {
            String path = StringUtils.lowerCase((String)this._path);
            return this._root.getPath() + "/" + path;
        }
        return this._root.getPath();
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)((UserPageFactory)this._factory).getPageDataTypeEP(), (RepositoryData)repositoryData);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePage) throws AmetysRepositoryException {
        ArrayList children = new ArrayList();
        return new CollectionIterable(children);
    }

    public boolean isVisible() throws AmetysRepositoryException {
        return false;
    }

    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        throw new UnknownAmetysObjectException("There is no child for user page");
    }

    public Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> getProfilesForAnonymousAndAnyConnectedUser() {
        Set collectionIds = ((UserPageFactory)this._factory).getSccHelper().getSynchronizableCollectionIds(this._syncContent);
        for (String collectionId : collectionIds) {
            Boolean restricted;
            String restrictedField;
            SynchronizableContentsCollection collection = ((UserPageFactory)this._factory).getSynchronizableContentsCollectionDAO().getSynchronizableContentsCollection(collectionId);
            if (collection == null || StringUtils.isEmpty((CharSequence)(restrictedField = collection.getRestrictedField())) || (restricted = (Boolean)this._syncContent.getValue(restrictedField)) == null || !restricted.booleanValue()) continue;
            return Map.of(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED, Set.of("READER"));
        }
        return Map.of();
    }

    public Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForGroups(Set<GroupIdentity> groups) {
        return Map.of();
    }

    public Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForUsers(UserIdentity user) {
        return Map.of();
    }

    public boolean isInheritanceDisallowed() {
        return false;
    }
}

