/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.synchronize;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.contentio.synchronize.impl.SQLSynchronizableContentsCollection;
import org.ametys.plugins.userdirectory.DeleteUserComponent;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.slf4j.Logger;

public class SQLSynchronizableUsersCollection
extends SQLSynchronizableContentsCollection {
    private static final String __PARAM_SQL_TABLE_LOGIN = "login";
    private static final String __PARAM_POPULATION_ID = "populationId";
    protected UserManager _userManager;
    protected DeleteUserComponent _deleteUserComponent;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._deleteUserComponent = (DeleteUserComponent)smanager.lookup(DeleteUserComponent.ROLE);
    }

    public boolean handleRightAssignmentContext() {
        return false;
    }

    public String getIdField() {
        return "uniqueId";
    }

    public Map<String, List<String>> getMapping() {
        Map mapping = super.getMapping();
        mapping.put(this.getIdField(), Collections.singletonList(this.getLoginSQLColumnName()));
        return mapping;
    }

    public String getLoginSQLColumnName() {
        return (String)this.getParameterValues().get(__PARAM_SQL_TABLE_LOGIN);
    }

    public String getPopulationId() {
        return (String)this.getParameterValues().get(__PARAM_POPULATION_ID);
    }

    protected Map<String, Object> _getSearchParameters(Map<String, Object> parameters, int offset, int limit, List<Object> sort, List<String> columns) {
        String loginSQLColumn = this.getLoginSQLColumnName();
        if (!columns.contains(loginSQLColumn)) {
            columns.add(loginSQLColumn);
        }
        return super._getSearchParameters(parameters, offset, limit, sort, columns);
    }

    protected boolean _checkIdObjectValue(String remoteKey, Object idObjectValue, Logger logger) {
        if (!super._checkIdObjectValue(remoteKey, idObjectValue, logger)) {
            return false;
        }
        String login = idObjectValue.toString();
        String population = this.getPopulationId();
        if (this._userManager.getUser(population, login) == null) {
            logger.warn("The user " + login + " don't belong to population " + population);
            return false;
        }
        return true;
    }

    protected Map<String, Object> getAdditionalAttributeValues(String idValue, Content content, Map<String, Object> additionalParameters, boolean create, Logger logger) {
        Map additionalRemoteValues = super.getAdditionalAttributeValues(idValue, content, additionalParameters, create, logger);
        UserIdentity user = new UserIdentity(idValue, this.getPopulationId());
        additionalRemoteValues.put("user", user);
        return additionalRemoteValues;
    }

    protected int _deleteContents(List<Content> contentsToRemove, Logger logger) {
        return this._deleteUserComponent.deleteContentsWithLog(contentsToRemove, Map.of("sccId", this.getId()), Map.of(), logger);
    }
}

