/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.userdataprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.data.File;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.User;
import org.ametys.core.user.dataprovider.UserDataProvider;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.userdirectory.userdataprovider.UserDirectoryImageAccessor;
import org.ametys.runtime.util.Labelable;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class ContentUserDataProvider
implements UserDataProvider,
Serviceable,
Initializable,
Contextualizable {
    public static final String USER_CONTENT_IMAGE_PATH = "illustration/image";
    private static final Comparator<Content> __COMPARATOR = Comparator.comparing(AmetysObject::getName);
    private Set<String> _supportedData;
    private UserDirectoryHelper _userDirectoryHelper;
    private ContentTypesHelper _contentTypesHelper;
    private Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._userDirectoryHelper = (UserDirectoryHelper)((Object)manager.lookup(UserDirectoryHelper.ROLE));
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public int getPriority() {
        return 10000;
    }

    public void initialize() throws Exception {
        this._supportedData = new HashSet<String>();
        Map contentTypesList = this._contentTypesHelper.getContentTypesList(Collections.singletonList("org.ametys.plugins.userdirectory.Content.user"), true, false, true, false, false);
        List contentTypes = (List)contentTypesList.get("contentTypes");
        for (Map contentType : contentTypes) {
            Collection modelItems = this._contentTypesHelper.getModelItems((String[])List.of(contentType.get("id")).toArray(String[]::new));
            this._supportedData.addAll(modelItems.stream().map(Labelable::getName).collect(Collectors.toSet()));
        }
    }

    public boolean supports(String element) {
        return "image".equals(element) || this._supportedData.contains(element);
    }

    public boolean hasValue(User user, String dataId) {
        List<Content> contentUsers = this._getSortedContentUsers(user);
        String dataIdToCheck = "image".equals(dataId) ? USER_CONTENT_IMAGE_PATH : dataId;
        for (Content contentUser : contentUsers) {
            if (!this.hasValue(contentUser, dataIdToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean hasValue(Content contentUser, String dataId) {
        return contentUser != null && contentUser.hasValue(dataId);
    }

    public Object getValue(User user, String dataId) {
        List<Content> contentUsers = this._getSortedContentUsers(user);
        String dataIdToCheck = "image".equals(dataId) ? USER_CONTENT_IMAGE_PATH : dataId;
        for (Content contentUser : contentUsers) {
            if (!this.hasValue(contentUser, dataIdToCheck)) continue;
            Object value = contentUser.getValue(dataIdToCheck);
            if (USER_CONTENT_IMAGE_PATH.equals(dataIdToCheck) && value != null && value instanceof File) {
                File file = (File)value;
                return new UserDirectoryImageAccessor(file);
            }
            return value;
        }
        return null;
    }

    private List<Content> _getSortedContentUsers(User user) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String lang = WebHelper.findLanguage((Request)request);
        ArrayList<Content> userContents = new ArrayList<Content>(this._userDirectoryHelper.getUserContents(user.getIdentity(), lang));
        userContents.sort(__COMPARATOR);
        return userContents;
    }
}

