<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:orgUnit="org.ametys.plugins.userdirectory.transformation.xslt.OrgUnitXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              extension-element-prefixes="orgUnit resolver">

	<xsl:import href="udorgunit.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-css-class-name">udorgunit view-link</xsl:variable>
    
    
    <!-- +
         | BODY
         + -->
    <!-- Empty title for link view--> 
    <xsl:template name="common-content-body-title"/>
        
    <!-- Used in common.xsl -->
    <xsl:template name="common-content-body-content">
        <xsl:call-template name="common-content-body-link"/>
    </xsl:template> 
    
    
    <xsl:template name="common-content-body-link">
        <xsl:variable name="page-id"><xsl:value-of select="orgUnit:getOrgUnitPage(@id)"/></xsl:variable>
        <xsl:if test="$page-id != ''">
            <a class="orgunit-link" href="{resolver:resolve('page', $page-id, false)}"><xsl:value-of select="metadata/title" /></a>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
