/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.forms;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.holder.DataHolderRelativeDisableCondition;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditions;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditionsHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;

public class FormQuestionUDHelper
implements Serviceable,
Component {
    public static final String ROLE = FormQuestionUDHelper.class.getName();
    public static final String ATTRIBUTE_USER_CONTENT_TYPE = "user-content-type";
    public static final String ATTRIBUTE_UD_USER_ATTRIBUTE_NAME = "ud-user-info";
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected UserDirectoryHelper _udHelper;
    protected FormDAO _formDAO;
    protected DataHolderRelativeDisableConditionsHelper _disableConditionsHelper;
    protected FormElementDefinitionHelper _formElementDefinitionHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._udHelper = (UserDirectoryHelper)((Object)manager.lookup(UserDirectoryHelper.ROLE));
        this._formDAO = (FormDAO)manager.lookup(FormDAO.ROLE);
        this._disableConditionsHelper = (DataHolderRelativeDisableConditionsHelper)manager.lookup(DataHolderRelativeDisableConditionsHelper.ROLE);
        this._formElementDefinitionHelper = (FormElementDefinitionHelper)manager.lookup(FormElementDefinitionHelper.ROLE);
    }

    public Object getUserContentAttributeValue(FormQuestion question, UserIdentity user) {
        String contentTypeId = (String)question.getValue(ATTRIBUTE_USER_CONTENT_TYPE);
        String userAttribute = (String)question.getValue("ud-user-info-" + contentTypeId.replace(".", "-"));
        List<Content> userContents = this._udHelper.getUserContents(user, this._formDAO.getFormLocale(question.getForm()));
        Optional<Content> userContent = userContents.stream().filter(u -> ArrayUtils.contains((Object[])u.getTypes(), (Object)contentTypeId)).findAny();
        return userContent.isPresent() ? userContent.get().getValue(userAttribute) : null;
    }

    public Map<String, ModelItem> getUDModelItems(List<String> acceptedTypes) {
        LinkedHashMap<String, ModelItem> modelItems = new LinkedHashMap<String, ModelItem>();
        ElementDefinition contentTypes = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_USER_CONTENT_TYPE, "string", "plugin.user-directory:PLUGINS_USER_DIRECTORY_QUESTIONS_DIALOG_COMPUTING_CONTENT_TYPE", "plugin.user-directory:PLUGINS_USER_DIRECTORY_QUESTIONS_DIALOG_COMPUTING_CONTENT_TYPE_DESC", (Validator)new DefaultValidator(null, true));
        StaticEnumerator contentTypesStaticEnumerator = new StaticEnumerator();
        contentTypes.setEnumerator((Enumerator)contentTypesStaticEnumerator);
        modelItems.put(contentTypes.getName(), (ModelItem)contentTypes);
        for (String ctId : this._contentTypeEP.getSubTypes("org.ametys.plugins.userdirectory.Content.user")) {
            ContentType contentType = (ContentType)this._contentTypeEP.getExtension(ctId);
            contentTypesStaticEnumerator.add(contentType.getLabel(), (Object)ctId);
            ElementDefinition<String> contentAttributes = this._getContentAttributesModelItem(acceptedTypes, ctId, contentType);
            modelItems.put(contentAttributes.getName(), (ModelItem)contentAttributes);
        }
        return modelItems;
    }

    private ElementDefinition<String> _getContentAttributesModelItem(List<String> acceptedTypes, String ctId, ContentType contentType) {
        ElementDefinition contentAttributes = this._formElementDefinitionHelper.getElementDefinition("ud-user-info-" + ctId.replace(".", "-"), "string", "plugin.user-directory:PLUGINS_USER_DIRECTORY_QUESTIONS_DIALOG_COMPUTING_UD_USERS", "plugin.user-directory:PLUGINS_USER_DIRECTORY_QUESTIONS_DIALOG_COMPUTING_UD_USERS_DESC", (Validator)new DefaultValidator(null, true));
        StaticEnumerator<String> userInfoStaticEnumerator = this._getContentTypeAttributesEnumerator(contentType, acceptedTypes);
        contentAttributes.setDisableConditions(this._getUDAttributeDisableCondition(ctId));
        contentAttributes.setEnumerator(userInfoStaticEnumerator);
        return contentAttributes;
    }

    private DisableConditions _getUDAttributeDisableCondition(String ctId) {
        DataHolderRelativeDisableConditions disableConditions = new DataHolderRelativeDisableConditions();
        DataHolderRelativeDisableCondition condition = new DataHolderRelativeDisableCondition(ATTRIBUTE_USER_CONTENT_TYPE, DisableCondition.OPERATOR.NEQ, ctId, this._disableConditionsHelper);
        disableConditions.getConditions().add(condition);
        disableConditions.setAssociation(DisableConditions.ASSOCIATION_TYPE.OR);
        return disableConditions;
    }

    private StaticEnumerator<String> _getContentTypeAttributesEnumerator(ContentType contentType, List<String> acceptedTypes) {
        StaticEnumerator userInfoStaticEnumerator = new StaticEnumerator();
        for (ModelItem modelItem : contentType.getModelItems()) {
            ElementDefinition elmtDef;
            if (!acceptedTypes.contains(modelItem.getType().getId()) || !(modelItem instanceof ElementDefinition) || (elmtDef = (ElementDefinition)modelItem).isMultiple()) continue;
            userInfoStaticEnumerator.add(modelItem.getLabel(), (Object)modelItem.getPath());
        }
        return userInfoStaticEnumerator;
    }
}

