/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.synchronize;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.contentio.synchronize.impl.LDAPSynchronizableContentsCollection;
import org.ametys.plugins.userdirectory.DeleteUserComponent;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.slf4j.Logger;

public class LDAPSynchronizableUsersCollection
extends LDAPSynchronizableContentsCollection {
    private static final String __PARAM_LDAP_TABLE_LOGIN = "login";
    private static final String __PARAM_POPULATION_ID = "populationId";
    protected UserManager _userManager;
    protected DeleteUserComponent _deleteUserComponent;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._deleteUserComponent = (DeleteUserComponent)smanager.lookup(DeleteUserComponent.ROLE);
    }

    public boolean handleRightAssignmentContext() {
        return false;
    }

    public String getIdField() {
        return "uniqueId";
    }

    public Map<String, List<String>> getMapping() {
        Map mapping = super.getMapping();
        mapping.put(this.getIdField(), List.of(this.getLoginLDAPColumnName()));
        return mapping;
    }

    public String getLoginLDAPColumnName() {
        return (String)this.getParameterValues().get(__PARAM_LDAP_TABLE_LOGIN);
    }

    public String getPopulationId() {
        return (String)this.getParameterValues().get(__PARAM_POPULATION_ID);
    }

    protected Map<String, Map<String, Object>> internalSearch(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger) {
        Map internalSearch = super.internalSearch(searchParameters, offset, limit, sort, logger);
        String population = this.getPopulationId();
        HashMap<String, Map<String, Object>> filteredSearchResult = new HashMap<String, Map<String, Object>>();
        for (String login : internalSearch.keySet()) {
            if (this._userManager.getUser(population, login) != null) {
                filteredSearchResult.put(login, (Map)internalSearch.get(login));
                continue;
            }
            logger.warn("The user " + login + " don't belong to population " + population);
        }
        return filteredSearchResult;
    }

    protected Map<String, Object> getAdditionalAttributeValues(String idValue, Content content, Map<String, Object> additionalParameters, boolean create, Logger logger) {
        Map additionalRemoteValues = super.getAdditionalAttributeValues(idValue, content, additionalParameters, create, logger);
        UserIdentity user = new UserIdentity(idValue, this.getPopulationId());
        additionalRemoteValues.put("user", user);
        return additionalRemoteValues;
    }

    protected int _deleteContents(List<Content> contentsToRemove, Logger logger) {
        return this._deleteUserComponent.deleteContentsWithLog(contentsToRemove, Map.of("sccId", this.getId()), Map.of(), logger);
    }
}

