<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">ud-user</xsl:variable>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-head-other">
        <!-- Copy CSS and script -->
        <xsl:copy-of select="/content/html/head/node()[local-name() != 'title' and local-name() != 'meta']"/>
    </xsl:template>

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-service-body-nonempty-content-title-content">
                <xsl:with-param name="title" select="$header"/>
            </xsl:call-template>  
        </xsl:variable>
            
        <xsl:apply-templates select="/content/html/body/node()" mode="move-hierarchy">
            <xsl:with-param name="level">
                <xsl:choose>
                    <xsl:when test="$raw-is-title-visible != ''">2</xsl:when>
                    <xsl:otherwise>1</xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
        </xsl:apply-templates>  
    </xsl:template>
</xsl:stylesheet>
