/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This controller allows to set/update/remove the property of a page as root of user directory.
 */
Ext.define('Ametys.plugins.userdirectory.SetUserDirectoryRootController', {
    extend: 'Ametys.web.controller.WebButtonController',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * @private
     * Listener handler for modified messages
     * @param {Ametys.message.Message} message the message
     */
    _onModified: function(message)
    {
        if (this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
    },
    
    updateState: function()
    {
        this._getStatus(this.getMatchingTargets());
    },
    
    /**
     * @private
     * Get the status
     * @param targets The page targets
     */
    _getStatus: function(targets)
    {
        this.disable();
        
        if (targets.length == 1)
        {
            var pageId = targets[0].getParameters().id;

            this.serverCall('getStatus',
                    [pageId], 
                    Ext.bind(this._getStatusCb, this),
                    { 
                        errorMessage: true,
                        refreshing: true
                    }
            );
        }
    },
    
    /**
     * @private
     * Callback for the button reloading process
     * @param {Object} params the server's response
     */
    _getStatusCb: function(params)
    {
        this._updateTooltipDescription("", params);
        
        this.toggle(params['user-directory-page-id'] != null);
        this.setDisabled(params['no-jcr-page-id'] != null);
    },
    
    /**
     * @private
     * Update the tooltip description according state of the current selection
     * @param {String} description The initial description. Can be empty.
     * @param {Object} params The JSON result received
     */
    _updateTooltipDescription: function(description, params)
    {
        if (params['user-directory-page-id'])
        {
           description = this._addToDescription(description, 'user-directory-page', params['user-directory-page-title']);
           if (params['contenttype-user-directory-page-description'])
           {
                description += " " + params['contenttype-user-directory-page-description'];
           }
           description = this._addToDescription(description, 'remove-user-directory-page', params['remove-user-directory-page-title']);
        }
        else if (params['no-jcr-page'])
        {
           description = this._addToDescription(description, 'no-jcr-page', params['no-jcr-page-title']);
        }
        else
        {
           description = this._addToDescription(description, 'add-user-directory-page', params['add-user-directory-page-title']);
        }
        
        this.setDescription(description);
    },
    
    /**
     * @private
     * Add text to description
     * @param {String} description The initial description to concatenate. Can be empty.
     * @param {String} prefix The parameters prefix to used to retrieve the start and end description. The start and end description are retrieved from initial configuration with [prefix]-start-description and [prefix]-end-description
     * @param {String} middleDescription The middle description
     * @return {String} The concatenated description
     */
    _addToDescription: function(description, prefix, middleDescription)
    {
        if (description != "")
        {
            description += "<br/><br/>";
        }
        
        description += this.getInitialConfig(prefix + "-start-description");
        description += middleDescription;
        description += this.getInitialConfig(prefix + "-end-description");
        return description;
    }
});
