<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
							  xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver i18n ametys">
                              
	<xsl:variable name="date-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_FORMAT', ametys:lang())"></xsl:variable>
    <xsl:variable name="date-time-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_TIME_FORMAT', ametys:lang())"></xsl:variable>
    
    <xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.form.ud.question.computing.UDUser']" mode ="render-js">
        <xsl:param name="title"/>
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        
        <!-- Do nothing -->
    </xsl:template>
    
    <xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.userdirectory.question.computing.UDUser']" mode="render-html">
        <xsl:param name="title"/>
        <xsl:param name="name"/>
        
        <!-- Do nothing -->
    </xsl:template>
    
    <xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.userdirectory.question.computing.UDUser']" mode ="render-mail">
        <xsl:param name="value"/>
        
        <xsl:apply-templates select="$value" mode="render-value" />
    </xsl:template>
    
    <xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.userdirectory.question.computing.UDUser']" mode="read-only-render-html">
        <xsl:param name="title"/>
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        
        <div class="computed" id="{$name}_{$uniqueId}"> 
            <div class="label">
                <label for="{$name}_{$uniqueId}">
                    <xsl:value-of select="$title" />
                </label>
            </div>
            <div class="{$cssPrefix}__item_value">
                <p class="text">
                    <span class="computed__value" >
                        <xsl:apply-templates select="$value" mode="render-value" />
                    </span>
                </p>
           </div>
        </div>
    </xsl:template>
    
    <xsl:template match="entry-value[additional-infos/computing-attribut-type='date']" mode="render-value">
        <xsl:if test="value != ''">
            <i18n:date src-pattern="yyyy-MM-dd" pattern="{$date-format}" value="{value}"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="entry-value[additional-infos/computing-attribut-type='datetime']" mode="render-value">
        <xsl:if test="value != ''">
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{value}"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="entry-value" mode="render-value">
        <xsl:value-of select="value" />
    </xsl:template>
    
</xsl:stylesheet>