/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.userdirectory.page;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.ametys.web.repository.page.virtual.ConfigurableVirtualZone;
import org.ametys.web.repository.page.virtual.ConfigurableVirtualZoneItem;
import org.ametys.web.repository.page.virtual.ConfigurableVirtualZoneItemFactory;

/**
 * {@link AmetysObjectFactory} handling {@link UserZoneItem}.
 */
public class UserZoneItemFactory extends ConfigurableVirtualZoneItemFactory
{
    /**
     * Create a zone item with its page, zoneName and id
     * @param page The zone item's page
     * @param zoneName The zone's name
     * @param zoneItemId The zone item's id
     * @return The created <code>ConfigurableVirtualZoneItem</code>
     */
    @Override
    public ConfigurableVirtualZoneItem createZoneItem(AbstractConfigurableVirtualPage page, String zoneName, String zoneItemId)
    {
        return new UserZoneItem(page, ((ConfigurableVirtualZone) page.getZone(zoneName)).getZoneItemConfiguration(zoneItemId), getScheme(), this);
    }
}
