/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.synchronize;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.user.population.PopulationConsumer;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;

/**
 * Implementation of {@link PopulationConsumer} allowing to know whether a population is used by the collections or not.
 */
public class CollectionPopulationConsumer implements PopulationConsumer, Serviceable
{
    /** The DAO for synchronizable contents collections */
    protected SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO) manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
    }
    
    @Override
    public boolean isInUse(String id)
    {
        for (SynchronizableContentsCollection collection : _synchronizableContentsCollectionDAO.getSynchronizableContentsCollections())
        {
            if (collection instanceof UserPopulationSynchronizableContentsCollection)
            {
                String populationId = ((UserPopulationSynchronizableContentsCollection) collection).getPopulationId();
                if (id.equals(populationId))
                {
                    return true;
                }
            }
        }
        return false;
    }
}
