/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.synchronize;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.cocoon.environment.Request;

/**
 * This impl cheats on the list on content types by calculating it itself 
 */
public class GetCommonAttributesAction extends org.ametys.cms.contenttype.GetCommonAttributesAction
{
    @Override
    protected Set<String> getContentTypes(Request request, boolean withResources)
    {
        Map<String, Object> contentTypesList = _contentTypesHelper.getContentTypesList(Collections.singletonList("org.ametys.plugins.userdirectory.Content.user"), 
                 true /* inherited */, 
                 false /* checkRights */, 
                 true /* includePrivate */, 
                 false /* includeMixins */, 
                 false /* includeAbstract*/);
        
        @SuppressWarnings("unchecked")
        List<Map<String, Object>> contentTypes = (List<Map<String, Object>>) contentTypesList.get("contentTypes");
        Set<String> contentTypesIds = contentTypes.stream().map(e -> (String) e.get("id")).collect(Collectors.toSet());
        return contentTypesIds;
    }
}
