/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.webanalytics.matomo;

/**
 * Exception when a error occurred with Matomo API
 */
public class MatomoException extends Exception
{
    /**
     * Constructs a new MatomoException.
     */
    public MatomoException()
    {
        super();
    }
    
    /**
     * Constructs a new MatomoException with the specified cause.
     * @param message the message of the exception.
     */
    public MatomoException(String message)
    {
        super(message);
    }
    
    /**
     * Constructs a new MatomoException with the specified cause.
     * @param message the message of the exception.
     * @param cause the cause of the exception
     */
    public MatomoException(String message, Throwable cause)
    {
        super(message, cause);
    }
}
