/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webanalytics.matomo.tracking;

import java.util.List;
import org.ametys.plugins.webanalytics.matomo.tracking.MatomoTrackingProvider;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.matomo.java.tracking.MatomoRequest;
import org.matomo.java.tracking.MatomoRequests;

public abstract class AbstractMatomoEventTrackingProvider
extends AbstractLogEnabled
implements MatomoTrackingProvider,
Configurable {
    protected String _eventsCategory;
    protected String _eventsAction;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._eventsCategory = configuration.getChild("category").getValue();
        this._eventsAction = configuration.getChild("action").getValue();
    }

    @Override
    public List<MatomoRequest> getRequests(Site site) {
        String matomoSiteId = (String)site.getValue("piwik-id");
        return this.getEvents(site).stream().map(e -> this._getRequest(site, matomoSiteId, (MatomoEvent)e)).toList();
    }

    private MatomoRequest _getRequest(Site site, String matomoSiteId, MatomoEvent event) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Sending request to Matomo: idsite={}&e_c={}&e_a={}&e_n={}&e_v={}", new Object[]{matomoSiteId, this.getEventsCategory(), this.getEventsAction(), event.name(), event.count()});
        }
        return MatomoRequests.event((String)this.getEventsCategory(), (String)this.getEventsAction(), (String)event.name(), event.count() > 0.0 ? Double.valueOf(event.count()) : null).siteId(Integer.valueOf(matomoSiteId)).userId("--AmetysServer--").actionUrl(site.getUrl() + "/tracking-url").build();
    }

    protected String getEventsCategory() {
        return this._eventsCategory;
    }

    protected String getEventsAction() {
        return this._eventsAction;
    }

    protected abstract List<MatomoEvent> getEvents(Site var1);

    public record MatomoEvent(String name, double count) {
    }
}

